#!/usr/bin/gnuplot

set term png size 2048,1024
set out "meteomod.png"

set xl ""
set yl "p of coming from a source [1]"
set cbl "source [1]" offset 1,0

set yr [-0.05:1.05]
set noxtics
set x2tics
set palette rgbformulae 33,13,10
set bmargin 12

p \
  "<sort -k1 -g meteomod.out" u 1:3:1 w lp lw 3 ps 2 lc palette z not,\
  "meteomod.out" u 1:(-0.05):(sprintf("  %s  ", stringcolumn(4))) w labels rotate by 90 right not,\
  "<awk '/# dsg/{ dsg=$4; }!/^#/ && ($3>0.5){ print $0,dsg; }' meteomod.out" u 1:3:(sprintf("   %s   ", stringcolumn(14))) w labels left not,\
  0.0 w l lt 0 not,\
  1.0 w l lt 0 not

q


