<html>
<head>
<title>METEOMOD: An advanced orbital distribution model for meteoroids</title>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
<script src="meteomod.js"></script>
</head>

<body>

<h1>METEOMOD: An advanced orbital distribution model for meteoroids</h1>

<p>
[ <!a href="../meteomod/meteomod.php">METEOMOD</a>
| <a href="../neomod/neomod.php">NEOMOD</a>
| <a href="../meteomod/meteomod.html">Documentation</a>
| <a href="meteomod.tar.gz">Download</a>
]

<p>Compute a probability of coming from a source.
See <a href="examples.html">examples</a>.

<p><small>Note:
In this example, the pre-atmospheric orbits of L chondrites are used (from <a href="http://meteoriteorbits.info">Meier 2023</a>).
A user should select the corresponding L-chondrite-like sources.
A conclusion is that 'all' come from Massalia<sub><small>(2)</small></sub>
(<a href="https://ui.adsabs.harvard.edu/abs/2024Natur.634..561M/abstract">Marsset et al. (2024)</a>)!
</small>

<?php

//ini_set("display_errors", "1"); error_reporting(E_ALL);

$orbits = $_GET['orbits'];
$c = $_GET['c'];
//echo(implode(",", $c));

if (!isset($orbits)) {

  $orbits = <<<EOF
1.1269 0.2285 24.22 "Antonin" L5
1.125 0.386 4.55 "Traspena" L5
2 0.533 5 "Kindberg" L6
0.889 0.327 0.12 "Madura_Cave" L5
1.451 0.60866 8.755 "Novo_Mesto" L5
1.82 0.460 4.0 "Cavezzo" L5-an
1.217 0.391 11.47 "Viñales" L6
0.84 0.199 18.44 "Ozerki" L6
1.486 0.3406 13.20 "Osceola" L6
1.300 0.410 4.228 "Creston" L6
2.54 0.64 8.6 "Porangaba" L4
2.093 0.6792 2.796 "Žd'ár_nad_Sázavou" L3
2.088 0.526 5.508 "Novato" L6
1.75 0.431 9.6 "Jesenice" L6
2.3 0.63 0.0 "Villalbeto_de_la_Peña" L6
2.53 0.680 3.2 "Park_Forest" L5
1.87 0.473 12.27 "Innisfree" L5
EOF;

}

if (isset($c)) { $chk = ""; } else { $chk = " checked"; }
if (isset($c)) { for ($i=0; $i<sizeof($c); $i++) { $d[$c[$i]] = " checked"; } }
//echo(implode(",", $d));

if (isset($_GET['Compute'])) {

  file_put_contents("orbits.tmp", $orbits);
  file_put_contents("maps.tmp", implode("\n", $c));

  system("./meteomod.py");
  system("gnuplot ./meteomod.plt");

  $meteomod = file_get_contents("meteomod.out");
  $tmp = filemtime("meteomod.png");

  $tmp_ = urlencode($orbits);

  echo <<<EOF

<p>

<p><a href="meteomod.png?$tmp"><img src="meteomod.png?$tmp" width="1024" border="1"></a>

<p><b>Maps:</b>
<a href="map.php?orbits=$tmp_&map=4">Vesta</a> 
<a href="map.php?orbits=$tmp_&map=25">Phocaea</a>
<a href="map.php?orbits=$tmp_&map=170">Maria</a>
<a href="map.php?orbits=$tmp_&map=808">Merxia</a>
<a href="map.php?orbits=$tmp_&map=847">Agnia</a>
<a href="map.php?orbits=$tmp_&map=158">Koronis</a>
<a href="map.php?orbits=$tmp_&map=158'">Koronis<sub><small>(2)</small></sub></a>
<a href="map.php?orbits=$tmp_&map=832">Karin</a>
<a href="map.php?orbits=$tmp_&map=20">Massalia</a>
<a href="map.php?orbits=$tmp_&map=20'">Massalia<sub><small>(2)</small></sub></a>
<a href="map.php?orbits=$tmp_&map=1272">Gefion</a>
<a href="map.php?orbits=$tmp_&map=3">Juno</a>
<a href="map.php?orbits=$tmp_&map=8">Flora</a>
<a href="map.php?orbits=$tmp_&map=15">Eunomia</a>
<a href="map.php?orbits=$tmp_&map=44">Nysa</a>
<a href="map.php?orbits=$tmp_&map=144">Vibilia</a>
<a href="map.php?orbits=$tmp_&map=145">Adeona</a>
<a href="map.php?orbits=$tmp_&map=163">Erigone</a>
<a href="map.php?orbits=$tmp_&map=410">Chloris</a>
<a href="map.php?orbits=$tmp_&map=490">Veritas</a>
<a href="map.php?orbits=$tmp_&map=668">Dora</a>
<a href="map.php?orbits=$tmp_&map=778">Theobalda</a>
<a href="map.php?orbits=$tmp_&map=1128">Astrid</a>
<a href="map.php?orbits=$tmp_&map=3815">König</a>
<a href="map.php?orbits=$tmp_&map=10">Hygiea</a>
<a href="map.php?orbits=$tmp_&map=24">Themis</a>
<a href="map.php?orbits=$tmp_&map=31">Euphrosyne</a>
<a href="map.php?orbits=$tmp_&map=128">Nemesis</a>
<a href="map.php?orbits=$tmp_&map=142">Polana</a>
<a href="map.php?orbits=$tmp_&map=302">Clarissa</a>
<a href="map.php?orbits=$tmp_&map=375">Ursula</a>
<a href="map.php?orbits=$tmp_&map=569">Misa</a>
<a href="map.php?orbits=$tmp_&map=618">Elfriede</a>
<a href="map.php?orbits=$tmp_&map=656">Beagle</a>
<a href="map.php?orbits=$tmp_&map=702">Alauda</a>
<a href="map.php?orbits=$tmp_&map=845">Naema</a>
<a href="map.php?orbits=$tmp_&map=1726">Hoffmeister</a>
<a href="map.php?orbits=$tmp_&map=3556">Lixiaohua</a>
<a href="map.php?orbits=$tmp_&map=283">Emma</a>
<a href="map.php?orbits=$tmp_&map=363">Padua</a>
<a href="map.php?orbits=$tmp_&map=2">Pallas</a>
<a href="map.php?orbits=$tmp_&map=221">Eos</a>
<a href="map.php?orbits=$tmp_&map=729">Watsonia</a>
<a href="map.php?orbits=$tmp_&map=298">Baptistina</a>
<a href="map.php?orbits=$tmp_&map=396">Aeolia</a>
<a href="map.php?orbits=$tmp_&map=22">Kalliope</a>
<a href="map.php?orbits=$tmp_&map=293">Brasilia</a>
<a href="map.php?orbits=$tmp_&map=369">Aeria</a>
<a href="map.php?orbits=$tmp_&map=606">Brangane</a>
<a href="map.php?orbits=$tmp_&map=1222">Tina</a>
<a href="map.php?orbits=$tmp_&map=44'">Nysa</a>
<a href="map.php?orbits=$tmp_&map=434">Hungaria</a>
<a href="map.php?orbits=$tmp_&map=87">Sylvia</a>
<a href="map.php?orbits=$tmp_&map=3200">Phaethon</a>
<a href="map.php?orbits=$tmp_&map=4652">Iannini</a>

<p><textarea cols="132" rows="24">
$meteomod
</textarea>

EOF ;

}

echo <<<EOF

<form action="meteomod.php" method="get">

<p>Orbits:

<input type="button" value="Clear" onClick="clear_()">

1. <i>a</i> [au] 2. <i>e</i> [1] 3. <i>i</i> [deg] 4. designation

<p><textarea name="orbits" cols="80" rows="8">
$orbits
</textarea>

<p>Sources:

<input type="button" value="All" onClick="all_()">
<input type="button" value="None" onClick="none()">

<p><table>
<tr valign="top">
<td>

<table>
<tr><td nowrap><input type="checkbox" name="c[]" class="hed" value="4" $d[4] $chk>Vesta (HED)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="h" onClick="group(this)">all H</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="25"   $d[25]       $chk>Phocaea (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="170"  $d[170]      $chk>Maria (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="808"  $d[808]      $chk>Merxia (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="847"  $d[847]      $chk>Agnia (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="158"  $d[158]      $chk>Koronis (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="158'" ${d["158'"]} $chk>Koronis<sub><small>(2)</small></sub> (H)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="h" value="832"  $d[832]      $chk>Karin (H)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="l" onClick="group(this)">all L</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="l" value="20"   $d[20]      $chk>Massalia (L)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="l" value="20'"  ${d["20'"]} $chk>Massalia<sub><small>(2)</small></sub></b> (L)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="l" value="1272" $d[1272]    $chk>Gefion (L)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="l" value="3"    $d[3]       $chk>Juno (L/LL)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="ll" onClick="group(this)">all LL</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ll" value="8"  $d[8]  $chk>Flora (LL)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ll" value="15" $d[15] $chk>Eunomia (LL)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ll" value="44" $d[44] $chk>Nysa (LL)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="cm" onClick="group(this)">all CM</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="144"  $d[144]  $chk>Vibilia (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="145"  $d[145]  $chk>Adeona (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="163"  $d[163]  $chk>Erigone (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="410"  $d[410]  $chk>Chloris (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="490"  $d[490]  $chk><b>Veritas (CM)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="668"  $d[668]  $chk>Dora (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="778"  $d[778]  $chk><b>Theobalda (CM)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="1128" $d[1128] $chk>Astrid (CM)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="cm" value="3815" $d[3815] $chk><b>König (CM)</b></td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="ci" onClick="group(this)">all CI</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="10"   $d[10]   $chk>Hygiea (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="24"   $d[24]   $chk>Themis (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="31"   $d[31]   $chk><b>Euphrosyne (CI)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="128"  $d[128]  $chk>Nemesis (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="142"  $d[142]  $chk><b>Polana (CI)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="302"  $d[302]  $chk><b>Clarissa (CI)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="375"  $d[375]  $chk>Ursula (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="569"  $d[569]  $chk><b>Misa (CI)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="618"  $d[618]  $chk>Elfriede (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="656"  $d[656]  $chk>Beagle (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="702"  $d[702]  $chk>Alauda (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="845"  $d[845]  $chk>Naema (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="1726" $d[1726] $chk><b>Hoffmeister (CI)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="3556" $d[3556] $chk>Lixiaohua (CI)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="283"  $d[283]  $chk>Emma (IDP)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="363"  $d[363]  $chk>Padua (IDP)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="ci" value="2"    $d[2]    $chk>Pallas (B)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="co" onClick="group(this)">all CO/CV/CK</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="co" value="221" $d[221] $chk>Eos (CO/CV/CK)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="co" value="729" $d[729] $chk>Watsonia (CO/CV/CK)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="?" onClick="group(this)">all ?</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="?"  value="298" $d[298] $chk><b>Baptistina (?)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="?"  value="396" $d[396] $chk><b>Aeolia (?)</b></td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="m" onClick="group(this)">all M</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="m" value="22"   $d[22]   $chk>Kalliope (M)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="m" value="293"  $d[293]  $chk>Brasilia (CH)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="m" value="369"  $d[369]  $chk>Aeria (M)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="m" value="606"  $d[606]  $chk><b>Brangäne (M)</b></td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="m" value="1222" $d[1222] $chk>Tina (M)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="e" onClick="group(this)">all E</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="e" value="44'" ${d["44'"]} $chk>Nysa (E)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="e" value="434" $d[434]     $chk>Hungaria (E)</td></tr>
</table>

</td><td>

<table>
<tr><td nowrap><input type="checkbox" class="o" onClick="group(this)">other</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="o" value="87"   $d[87]   $chk>Sylvia (P)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="o" value="3200" $d[3200] $chk>Phaethon (CY?)</td></tr>
<!--
<tr><td nowrap><input type="checkbox" name="c[]" class="o" value="2732" $d[2732] $chk>Witt (?)</td></tr>
<tr><td nowrap><input type="checkbox" name="c[]" class="o" value="4203" $d[4203] $chk>Brucato (?)</td></tr>
-->
</table>

</td>
</tr>
</table>

<p><input type="submit" name="Compute" value="Compute">
<input type="reset" name="Reset" value="Reset">
<a href="meteomod.php">Back</a>

</form>

EOF ;

?>

<p>Miroslav Broz (miroslav.broz@email.cz), Mar 18th 2024

</body>
</html>


