#!/usr/bin/gnuplot

deg = pi/180.

load "aei2.lab"

set colors classic
set term post eps enh color solid "Helvetica,18"
set out "aei2.eps"

set xl "{/Helvetica-Oblique a}_p [au]"
set yl "{/Helvetica-Oblique e}_p" offset +1

set nokey
set lmargin 8.6
set rmargin 1.8
set bmargin 3.2
set tmargin 0.6

am = 1.5236633966611037
aj = 5.2031303413943251
r(a,i,j) = a*(1.0*i/j)**(-2./3.)
tmp=2.15; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0
i= 1; j=2; tmp=r(am,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 4; j=1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j=3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 7; j=2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=10; j=3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j=4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 3; j=1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=14; j=5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j=4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 8; j=3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j=5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 5; j=2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=17; j=7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=12; j=5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 7; j=3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=16; j=7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 9; j=4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j=5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j=6; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=15; j=7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=17; j=8; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=19; j=9; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 2; j=1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.2157; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.3977; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.4476; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.5599; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6155; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6190; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6230; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6857; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.7525; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.9095; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.9860; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.0790; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1385; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1418; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1708; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1738; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.2080; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front

load "COLOR_wise.plt"
load "family.rng"

p_V = 0.25
D(H, p_V) = 10.**(0.5*(6.259 - log10(p_V) - 0.4*H))
f_(D) = 0.2 + 2.0*(log10(D)-log10(0.1))/(3.-log10(0.1))

set size 0.9,1.52
set multiplot
set origin 0,0
set size 0.9,0.8

p \
  "<awk '($47 == \"?\")' family.list" u 36:37:(f_(D($35,p_V))) w p pt 7 ps variable lc 'gray',\
  "<awk '($47 != \"?\")' family.list" u 36:37:(f_($55)):(pV_pIR($57,$59)) w p pt 7 ps variable lc rgb variable,\
  "<awk '($47 == \"?\")' halo.list"   u 36:37:(f_(D($35,p_V))) w p pt 7 ps variable lc 'gray',\
  "<awk '($47 != \"?\")' halo.list"   u 36:37:(f_($55)):(pV_pIR($57,$59)) w p pt 7 ps variable lc rgb variable,\
  "family.label" u 36:37:34 w labels center,\
  "interlopers.out" u 36:37 w p pt 6 lt 2 ps 1,\

########################################################################

set origin 0,0.70

tmp=2.15; set label "{/Symbol n}_6" at tmp,graph 1.03 center font "Helvetica,14"
i= 1; j=2; tmp=r(am,i,j); set label sprintf("M%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 4; j=1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=11; j=3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 7; j=2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=10; j=3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=13; j=4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 3; j=1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=14; j=5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=11; j=4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 8; j=3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=13; j=5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 5; j=2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=17; j=7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=12; j=5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 7; j=3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=16; j=7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 9; j=4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=11; j=5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=13; j=6; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=15; j=7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=17; j=8; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i=19; j=9; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 2; j=1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.2157; set label "4-1-1" at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.3977; set label "4-2-1" at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.4476; set label "7-2-2" at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.5599; set label "7-3-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6155; set label "2+2-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6190; set label "6-1-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6230; set label "4-3-1" at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.6857; set label "7-4-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.7525; set label "3-1-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.9095; set label "4-4-1" at tmp,graph 1.03 center font "Helvetica,14"
tmp=2.9860; set label "5-1-2" at tmp,graph 1.03 right  font "Helvetica,14"
#tmp=3.0790; set label "3-2-1" at tmp,graph 1.03 center font "Helvetica,14"
tmp=3.1385; set label "6+1-3" at tmp,graph 1.03 center font "Helvetica,14"
tmp=3.1418; set label "8-4-3" at tmp,graph 1.03 center font "Helvetica,14"
tmp=3.1708; set label "3+3-2" at tmp,graph 1.03 center font "Helvetica,14"
tmp=3.1738; set label "5-2-2" at tmp,graph 1.03 center font "Helvetica,14"
tmp=3.2080; set label "7-2-3" at tmp,graph 1.03 center font "Helvetica,14"

set xl ""
set yl "sin {/Helvetica-Oblique I}_p" offset +1
set xtics format ""

p \
  "<awk '($47 == \"?\")' family.list" u 36:38:(f_(D($35,p_V))) w p pt 7 ps variable lc 'gray',\
  "<awk '($47 != \"?\")' family.list" u 36:38:(f_($55)):(pV_pIR($57,$59)) w p pt 7 ps variable lc rgb variable,\
  "<awk '($47 == \"?\")' halo.list"   u 36:38:(f_(D($35,p_V))) w p pt 7 ps variable lc 'gray',\
  "<awk '($47 != \"?\")' halo.list"   u 36:38:(f_($55)):(pV_pIR($57,$59)) w p pt 7 ps variable lc rgb variable,\
  "family.label" u 36:38:34 w labels center,\
  "interlopers.out" u 36:38 w p pt 6 lt 2 ps 1,\

unset multiplot
system("eps2png aei2.eps")

q


