#!/usr/bin/gnuplot

set encoding utf8

set term png enh size 2048,1024
set out "map.png"

set xl "{/Helvetica-Oblique a} [au]"
set yl "{/Helvetica-Oblique i} [deg]" offset -1,0
set cbl "{/Helvetica-Oblique n} of orbits in bin [1]"

set yr [0:90]
set cbr [0.1:]
set xtics 0.1
set pm3d map
set xyplane 0.0
set logscale cb
set palette rgbformulae 33,13,10

set lmargin at screen 0.04
set rmargin at screen 0.90
set bmargin at screen 0.05
set tmargin at screen 0.95

am = 1.5236633966611037	# osculating
aj = 5.2031303413943251	# oscilating
am = 1.52367949		# proper
aj = 5.20260048		# proper
r(a,i,j) = a*(1.0*i/j)**(-2./3.)
#print "a_J103 = ", r(aj,10,3), " au"
#print "a_M12 = ", r(am,1,2), " au"
tmp=2.15; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 1; j= 2; tmp=r(am,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 2; j= 3; tmp=r(am,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j= 2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 5; j= 1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 9; j= 2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j= 3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 4; j= 1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j= 3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 7; j= 2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=10; j= 3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j= 4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 3; j= 1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=14; j= 5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j= 4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 8; j= 3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j= 5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 5; j= 2; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=17; j= 7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=12; j= 5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 7; j= 3; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=16; j= 7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 9; j= 4; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j= 5; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j= 6; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=15; j= 7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=17; j= 8; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=19; j= 9; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i= 2; j= 1; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=21; j=11; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=19; j=10; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=17; j= 9; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=15; j= 8; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=13; j= 7; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=11; j= 6; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
i=20; j=11; tmp=r(aj,i,j); set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.2157; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.3977; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.4476; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.5599; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6155; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6190; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6230; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.6857; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.7525; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.9095; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=2.9860; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.0790; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1385; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1418; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.168 ; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1708; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.1738; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.180 ; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.2080; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.35  ; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.39  ; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front
tmp=3.43  ; set arrow from tmp,graph 0 rto 0,graph 1 nohead lt 0 front

tmp=2.15; set label "nu_6" at tmp,graph 1.03 center font "Helvetica,14"
#i= 2; j= 3; tmp=r(am,i,j); set label sprintf("M%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 1; j= 2; tmp=r(am,i,j); set label sprintf("M%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=11; j= 2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i= 5; j= 1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 9; j= 2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=13; j= 3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i= 4; j= 1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=11; j= 3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i= 7; j= 2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=10; j= 3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=13; j= 4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 3; j= 1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=14; j= 5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=11; j= 4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 8; j= 3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=13; j= 5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 5; j= 2; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=17; j= 7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=12; j= 5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 7; j= 3; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=16; j= 7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 9; j= 4; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=11; j= 5; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=13; j= 6; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=15; j= 7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=17; j= 8; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=19; j= 9; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
i= 2; j= 1; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=21; j=11; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=19; j=10; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=17; j= 9; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=15; j= 8; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=13; j= 7; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=11; j= 6; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#i=20; j=11; tmp=r(aj,i,j); set label sprintf("%d:%d",i,j) at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.2157; set label "4-1-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.3977; set label "4-2-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.4476; set label "7-2-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.5599; set label "7-3-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6155; set label "2+2-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6190; set label "6-1-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6230; set label "4-3-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.6857; set label "7-4-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.7525; set label "3-1-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.9095; set label "4-4-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=2.9860; set label "5-1-2" at tmp,graph 1.03 right  font "Helvetica,14"
#tmp=3.0790; set label "3-2-1" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.1385; set label "6+1-3" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.1418; set label "8-4-3" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.168 ; set label "3+3-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.1708; set label "3+3-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.1738; set label "5-2-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.180 ; set label "7-7-2" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.2080; set label "7-2-3" at tmp,graph 1.03 center font "Helvetica,14"
#tmp=3.35  ; set label "5+2-3" at tmp,graph 1.03 center font "Helvetica,14" 
#tmp=3.39  ; set label "5-3-2" at tmp,graph 1.08 center font "Helvetica,14" tc 'gray'
#tmp=3.43  ; set label "6-1-3" at tmp,graph 1.08 center font "Helvetica,14" tc 'gray'

sp \
  "map.out" u 3:4:5 w pm3d,\
  "../../orbits.in" u 1:3:(0.0) w p ps 5 lw 4 lc 'black' not,\
  "../../orbits.in" u 1:($3+3.5):(0.0):4 w labels not

#pa -1

#rep

q
  "<awk '/CM[0-9]*|C2-*|C1-*/' Tab1.dat"  u 11:17:(1.0) w p ps 5 lw 3 lc 'black' t "CM",\
  "<awk '/CM[0-9]*|C2-*|C1-*/' Tab1.dat"  u 11:17:(1000):13:19:19 w xyerr ps 0 lc '#0000aa' t "CM"

