#!/usr/bin/gnuplot

D = 1737*2
S = 4*pi*(D/2.)**2
f(N)=N/S

set term x11

set xl "D [km]"
set yl "n(>D) [km^-2]"

set logscale xy

p \
  "lunar_crater_database_robbins_2018.dat_hc" u 1:(f($2)) w l lw 1,\
  "../LICD/Lunar_Impact_Crater_Database_v08Sep2015.dat_hc" u 1:(f($2)) w lp lw 1,\
  "../Marchi_2009_Moon/4.35_highlands.dat"      u 1:2:(4.35) t "4.35 highlands"      w lp lc palette z,\

pa -1

q

  "../dat/Marchi_2009_Moon/3.92_Nectaris.dat"       u 1:2:(3.92) t "3.92 Nectaris"       w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.92_Descartes.dat"      u 1:2:(3.92) t "3.92 Descartes"      w lp lc palette z lw 2,\
  "../dat/Marchi_2009_Moon/3.85_Framauro.dat"       u 1:2:(3.85) t "3.85 Framauro"       w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.85_Apennines.dat"      u 1:2:(3.85) t "3.85 Apennines"      w lp lc palette z lw 2,\
  "../dat/Marchi_2009_Moon/3.80_Tranqulitatis2.dat" u 1:2:(3.80) t "3.80 Tranqulitatis2" w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.70_Tauruslittrow.dat"  u 1:2:(3.70) t "3.70 Tauruslittrow"  w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.58_Tranqulitatis.dat"  u 1:2:(3.58) t "3.58 Tranqulitatis"  w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.41_Fecundidatis.dat"   u 1:2:(3.41) t "3.41 Fecundidatis"   w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.30_Imbrium.dat"        u 1:2:(3.30) t "3.30 Imbrium"        w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.22_Crisium.dat"        u 1:2:(3.22) t "3.22 Crisium"        w lp lc palette z,\
  "../dat/Marchi_2009_Moon/3.15_Procellarum.dat"    u 1:2:(3.15) t "3.15 Procellarum"    w lp lc palette z,\
  "../dat/Marchi_2009_Moon/0.80_Copernicus.dat"     u 1:2:(0.80) t "0.80 Copernicus.dat" w lp lc palette z,\
  "../dat/Marchi_2009_Moon/0.11_Tycho.dat"          u 1:2:(0.11) t "0.11 Tycho"          w lp lc palette z,\

