#!/usr/bin/gnuplot

set colors classic
set term postscript eps enh color solid "Helvetica" 18
set out "Flora_Juno_Gefion_sfds.eps"
set size 0.65,0.9

set xl "diameter {/Helvetica-Oblique D} / km"
set yl "number of asteroids {/Helvetica-Oblique N} (>{/Helvetica-Oblique D})" offset +0.0

set xr [0.001:1000]
y1=0.8
y2=1.e13
set yr [y1:y2]
set logscale xy
set mxtics 10
set ytics (\
  ""     8e-1 1,\
  ""     9e-1 1,\
  "1"    1e0  0,\
  ""     2e0  1,\
  ""     3e0  1,\
  ""     4e0  1,\
  ""     5e0  1,\
  ""     6e0  1,\
  ""     7e0  1,\
  ""     8e0  1,\
  ""     9e0  1,\
  "10"   1e1  0,\
  ""     2e1  1,\
  ""     3e1  1,\
  ""     4e1  1,\
  ""     5e1  1,\
  ""     6e1  1,\
  ""     7e1  1,\
  ""     8e1  1,\
  ""     9e1  1,\
  "100"  1e2  0,\
  ""     2e2  1,\
  ""     3e2  1,\
  ""     4e2  1,\
  ""     5e2  1,\
  ""     6e2  1,\
  ""     7e2  1,\
  ""     8e2  1,\
  ""     9e2  1,\
  "1000" 1e3  0,\
  ""     2e3  1,\
  ""     3e3  1,\
  ""     4e3  1,\
  ""     5e3  1,\
  ""     6e3  1,\
  ""     7e3  1,\
  ""     8e3  1,\
  ""     9e3  1,\
  "{/=14 10^4}" 1e4  0,\
  ""     2e4  1,\
  ""     3e4  1,\
  ""     4e4  1,\
  ""     5e4  1,\
  ""     6e4  1,\
  ""     7e4  1,\
  ""     8e4  1,\
  ""     9e4  1,\
  "{/=14 10^5}" 1e5  0,\
  ""     2e5  1,\
  ""     3e5  1,\
  ""     4e5  1,\
  ""     5e5  1,\
  ""     6e5  1,\
  ""     7e5  1,\
  ""     8e5  1,\
  ""     9e5  1,\
  "{/=14 10^6}" 1e6  0,\
  ""     2e6  1,\
  ""     3e6  1,\
  ""     4e6  1,\
  ""     5e6  1,\
  ""     6e6  1,\
  ""     7e6  1,\
  ""     8e6  1,\
  ""     9e6  1,\
  "{/=14 10^7}" 1e7  0,\
  ""     2e7  1,\
  ""     3e7  1,\
  ""     4e7  1,\
  ""     5e7  1,\
  ""     6e7  1,\
  ""     7e7  1,\
  ""     8e7  1,\
  ""     9e7  1,\
  "{/=14 10^8}" 1e8  0,\
  ""     2e8  1,\
  ""     3e8  1,\
  ""     4e8  1,\
  ""     5e8  1,\
  ""     6e8  1,\
  ""     7e8  1,\
  ""     8e8  1,\
  ""     9e8  1,\
  "{/=14 10^9}" 1e9  0,\
  ""     2e9  1,\
  ""     3e9  1,\
  ""     4e9  1,\
  ""     5e9  1,\
  ""     6e9  1,\
  ""     7e9  1,\
  ""     8e9  1,\
  ""     9e9  1,\
  "{/=14 10^{10}}" 1e10 0,\
  ""     2e10 1,\
  ""     3e10 1,\
  ""     4e10 1,\
  ""     5e10 1,\
  ""     6e10 1,\
  ""     7e10 1,\
  ""     8e10 1,\
  ""     9e10 1,\
  "{/=14 10^{11}}" 1e11 0,\
  ""     2e11 1,\
  ""     3e11 1,\
  ""     4e11 1,\
  ""     5e11 1,\
  ""     6e11 1,\
  ""     7e11 1,\
  ""     8e11 1,\
  ""     9e11 1,\
  "{/=14 10^{12}}" 1e12 0,\
  ""     2e12 1,\
  ""     3e12 1,\
  ""     4e12 1,\
  ""     5e12 1,\
  ""     6e12 1,\
  ""     7e12 1,\
  ""     8e12 1,\
  ""     9e12 1,\
  "{/=14 10^{13}}" 1e13 0,\
  )
set grid noxtics noytics front
set key at graph 0.99,graph 0.98 samplen 1.5 spacing 1.3 font "Helvetica,14"

set style line 1 lc rgb '#0066ff' lw 2 pt 1		# evolved MB
set style line 2 lc rgb '#ff6600' lw 2 pt 1		# evolved family
set style line 3 lc rgb '#999999' lw 1 pt 1		# evolved NEA
set style line 4 lc rgb '#ffcc00' lw 4 dt 3		# initial MB
set style line 5 lc rgb '#bbbbff' pt 7 ps 0.8		# observed MB
set style line 6 lc rgb '#cccccc' pt 7 ps 0.8		# observed NEA

set lmargin 7.5
set rmargin 2.1
set bmargin 3.0
set tmargin 0.8

x1=0.2
x2=5
y1=1.e5
y2=1.e7

p \
  "<awk '(FNR==1){ print \"\"; } ($2==1)' ../24_MB_Flora/*[0-9]*/tmp/1200.out | ./hc.awk" u 1:2 w l ls 1 t "evolved MB",\
  "<awk '(FNR==1){ print \"\"; } ($2==2)' ../28_MB_Gefion/*[0-9]*/tmp/1200.out | ./hc.awk" u 1:2 w l lc '#aaaa00' t "evolved Gefion",\
  "<awk '(FNR==1){ print \"\"; } ($2==2)' ../27_MB_Juno/*[0-9]*/tmp/0750.out | ./hc.awk"   u 1:2 w l lc '#cccccc' t "evolved Juno",\
  "<awk '(FNR==1){ print \"\"; } ($2==2)' ../24_MB_Flora/*[0-9]*/tmp/1200.out | ./hc.awk"  u 1:2 w l lc '#ff6600' t "evolved Flora",\
  "../24_MB_Flora/dat/Bottke_etal_2015.dat" u (10.**$1):(10.**$2) w l ls 5 lw 3 dt 2 t "observed MB",\
  "<awk '($1>-1) && ($1<0.2)' ../24_MB_Flora/dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2*1.5) w l ls 5 lw 3 dt 2 not,\
  "../28_MB_Gefion/src/1272_Gefion_family.dat_hc" u 1:2 w l ls 5 lw 3 dt 2 t "observed Gefion",\
  "../27_MB_Juno/src/3_Juno_family.dat_hc"        u 1:2 w l ls 5 lw 3 dt 2 t "observed Juno",\
  "../24_MB_Flora/src/8_Flora_family.dat_hc"      u 1:2 w l ls 5 lw 3 dt 2 t "observed Flora",\

system("eps2png Flora_Juno_Gefion_sfds.eps")

q

  "<./hc_sfd.awk ../24_MB_Flora/src/sfd1.dat_EDITED" u 1:2 w l ls 4 t "initial MB"    ,\
  "<./hc_sfd.awk ../24_MB_Flora/src/sfd2.dat_EDITED" u 1:2 w l ls 4 t "initial Flora",\
  "<./hc_sfd.awk ../25_MB_Massalia/src/sfd2.dat_EDITED" u 1:2 w l ls 4 t "initial Massalia",\

  "../24_MB_Flora/dat/Bottke_etal_2015.dat"  u (10.**$1):(10.**$2) w p ls 5 t "{/=14 Bottke etal. (2015)}",\
  "<awk '($1>-1) && ($1<0.2)' ../24_MB_Flora/dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2*1.5) w p lc rgb '#ffffff' pt 7 ps 1.0 not,\
  "<awk '($1>-1) && ($1<0.2)' ../24_MB_Flora/dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2*1.5) w p ls 5 not,\
