#!/usr/bin/gnuplot

set colors classic
set term postscript eps enh color solid "Helvetica" 18
set out "sfd_4000_NEA.eps"
set size 0.65,0.9

set xl "diameter {/Helvetica-Oblique D} / km"
set yl "number of asteroids {/Helvetica-Oblique N} (>{/Helvetica-Oblique D})" offset +0.0

set xr [0.004:1000]
y1=0.8
y2=1.e9
set yr [y1:y2]
set logscale xy
set mxtics 10
set ytics (\
  ""     8e-1 1,\
  ""     9e-1 1,\
  "1"    1e0  0,\
  ""     2e0  1,\
  ""     3e0  1,\
  ""     4e0  1,\
  ""     5e0  1,\
  ""     6e0  1,\
  ""     7e0  1,\
  ""     8e0  1,\
  ""     9e0  1,\
  "10"   1e1  0,\
  ""     2e1  1,\
  ""     3e1  1,\
  ""     4e1  1,\
  ""     5e1  1,\
  ""     6e1  1,\
  ""     7e1  1,\
  ""     8e1  1,\
  ""     9e1  1,\
  "100"  1e2  0,\
  ""     2e2  1,\
  ""     3e2  1,\
  ""     4e2  1,\
  ""     5e2  1,\
  ""     6e2  1,\
  ""     7e2  1,\
  ""     8e2  1,\
  ""     9e2  1,\
  "1000" 1e3  0,\
  ""     2e3  1,\
  ""     3e3  1,\
  ""     4e3  1,\
  ""     5e3  1,\
  ""     6e3  1,\
  ""     7e3  1,\
  ""     8e3  1,\
  ""     9e3  1,\
  "10^4" 1e4  0,\
  ""     2e4  1,\
  ""     3e4  1,\
  ""     4e4  1,\
  ""     5e4  1,\
  ""     6e4  1,\
  ""     7e4  1,\
  ""     8e4  1,\
  ""     9e4  1,\
  "10^5" 1e5  0,\
  ""     2e5  1,\
  ""     3e5  1,\
  ""     4e5  1,\
  ""     5e5  1,\
  ""     6e5  1,\
  ""     7e5  1,\
  ""     8e5  1,\
  ""     9e5  1,\
  "10^6" 1e6  0,\
  ""     2e6  1,\
  ""     3e6  1,\
  ""     4e6  1,\
  ""     5e6  1,\
  ""     6e6  1,\
  ""     7e6  1,\
  ""     8e6  1,\
  ""     9e6  1,\
  "10^7" 1e7  0,\
  ""     2e7  1,\
  ""     3e7  1,\
  ""     4e7  1,\
  ""     5e7  1,\
  ""     6e7  1,\
  ""     7e7  1,\
  ""     8e7  1,\
  ""     9e7  1,\
  "10^8" 1e8  0,\
  ""     2e8  1,\
  ""     3e8  1,\
  ""     4e8  1,\
  ""     5e8  1,\
  ""     6e8  1,\
  ""     7e8  1,\
  ""     8e8  1,\
  ""     9e8  1,\
  "10^9" 1e9  0,\
  ""     2e9  1,\
  ""     3e9  1,\
  ""     4e9  1,\
  ""     5e9  1,\
  ""     6e9  1,\
  ""     7e9  1,\
  ""     8e9  1,\
  ""     9e9  1,\
  "10^{10}" 1e10 0,\
  )
set key samplen 1.5 spacing 1.3 font "Helvetica,14"

tmp=1; set arrow from tmp,graph 0 to tmp,graph 1 nohead lt 0

set style line 1 lc rgb '#0066ff' lw 2 pt 1		# evolved MB
set style line 2 lt 1 lw 1 pt 1				# evolved family
set style line 3 lc rgb '#999999' lw 1 pt 1		# evolved NEA
set style line 4 lc rgb '#ffaa00' lw 4 dt 3		# initial MB
set style line 5 lc rgb '#bbbbff' pt 7 ps 0.8		# observed MB
set style line 6 lc rgb '#cccccc' pt 7 ps 0.8		# observed NEA

set label "{/Helvetica-Bold=24 MB}" at 50,1e5 center tc rgb '#aaaaff'
set label "{/Helvetica-Bold=24 NEA}" at 0.1,500 center tc rgb '#888888'

set lmargin 7.5
set rmargin 2.1
set bmargin 3.0
set tmargin 0.8

p \
  "<./hc_sfd.awk sfd1.dat_EDITED" u 1:2 t "initial MB"     w l  ls 4,\
  "<awk '(FNR==1){ print \"\"; } ($2==1)' ../*[0-9]*/tmp/4000.out | ./hc.awk" u 1:2 t "evolved MB"     w l ls 1,\
  "<awk '(FNR==1){ print \"\"; } ($2==3)' ../*[0-9]*/tmp/4000.out | ./hc.awk" u 1:2 t "evolved NEA"    w l ls 3,\
  "../../dat/Bottke_etal_2015.dat"  u (10.**$1):(10.**$2) not w p lc rgb '#ffffff' pt 7 ps 1.0,\
  "../../dat/Harris_etal_2015.dat"  u (10.**$1):(10.**$2) not w p lc rgb '#ffffff' pt 7 ps 1.0,\
  "<awk '($1<0.2)' ../../dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2*1.5) not w p lc rgb '#ffffff' pt 7 ps 1.0,\
  "../../dat/Bottke_etal_2015.dat"  u (10.**$1):(10.**$2) t "{/=14 Bottke etal. (2015)}" w p ls 5,\
  "../../dat/Harris_etal_2015.dat"  u (10.**$1):(10.**$2) t "{/=14 Harris etal. (2015)}" w p ls 6,\
  "<awk '($1<0.2)' ../../dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2*1.5) not w p ls 5,\

q

#tmp=1.e6; set arrow from graph 0,first tmp to graph 1,first tmp nohead lt 0

#  "../src/MB_2018.dat_hc" u 1:2 t "observed MB" w l ls 5 lw 2,\
#  "../dat/Gladman_etal_2009.dat" u (10.**$1):(10.**$2) t "Gladman etal. (2009)" w l ls 5 dt 2,\
#  "../dat/Cibulkova_etal_2014_MB.dat_hc" u 1:2 t "Cibulkova etal. (2014)" w l ls 5,\
#  "<./hc_sfd.awk sfd3.dat_EDITED" u 1:2 t "initial NEA"    w l  ls 4,\
#  "<./hc_sfd.awk sfd2.dat_EDITED" u 1:2 t "initial family" w l  ls 4,\
#  "<awk '(FNR==1){ print \"\"; } ($2==2)' ../[0-9]*/tmp/4000.out | ./hc.awk" u 1:2 t "evolved family" w lp ls 2,\



