#!/usr/bin/gnuplot

load "D.lab"

S = 4*pi*(D/2.)**2
f(N)=N/S

set term x11

set xl "diameter {/Helvetica-Oblique D}_c / km"
set yl "number of craters {/Helvetica-Oblique N}(>{/Helvetica-Oblique D}) per km^2" offset -0.3,0

set xr [10:700]
set logscale xy
set xtics (\
  "1"   1   0,\
  "2"   2   0,\
  "3"   3   0,\
  "4"   4   0,\
  "5"   5   0,\
  "6"   6   1,\
  "7"   7   1,\
  "8"   8   1,\
  "9"   9   1,\
  "10"  10  0,\
  "20"  20  0,\
  "30"  30  1,\
  "40"  40  1,\
  "50"  50  0,\
  "60"  60  1,\
  "70"  70  1,\
  "80"  80  1,\
  "90"  90  1,\
  "100" 100 0,\
  "200" 200 0,\
  "300" 300 1,\
  "400" 400 1,\
  "500" 500 0,\
  "600" 600 1,\
  "700" 700 1,\
  "800" 800 1,\
  "900" 900 1,\
  "1000" 1000 0,\
  )
set ytics (\
  "10^{-6}" 1e-6 0,\
  ""        2e-6 1,\
  ""        3e-6 1,\
  ""        4e-6 1,\
  ""        5e-6 1,\
  ""        6e-6 1,\
  ""        7e-6 1,\
  ""        8e-6 1,\
  ""        9e-6 1,\
  "10^{-5}" 1e-5 0,\
  ""        2e-5 1,\
  ""        3e-5 1,\
  ""        4e-5 1,\
  ""        5e-5 1,\
  ""        6e-5 1,\
  ""        7e-5 1,\
  ""        8e-5 1,\
  ""        9e-5 1,\
  "10^{-4}" 1e-4 0,\
  ""        2e-4 1,\
  ""        3e-4 1,\
  ""        4e-4 1,\
  ""        5e-4 1,\
  ""        6e-4 1,\
  ""        7e-4 1,\
  ""        8e-4 1,\
  ""        9e-4 1,\
  "10^{-3}" 1e-3 0,\
  ""        2e-3 1,\
  ""        3e-3 1,\
  ""        4e-3 1,\
  ""        5e-3 1,\
  ""        6e-3 1,\
  ""        7e-3 1,\
  ""        8e-3 1,\
  ""        9e-3 1,\
  "10^{-2}" 1e-2 0,\
  )

tmp=40.; set arrow from tmp,graph 0 to tmp,graph 1 nohead lt 0

set colors classic
set key at graph 0.985,graph 0.975 spacing 1.5 samplen 1.0 width -3 font "Helvetica,14"
set nocolorbox
set lmargin 7.2
set rmargin 1.2
set tmargin 0.8
set bmargin 3.2

set palette defined (\
  0 '#ff6600',\
  1 '#ffcc00' \
  )

p \
  "<awk '(FNR==1){ print \"\"; } { print $0,ARGIND; }' ../*[0-9]*/craters_hist/craters_hist.dat_hc" u 1:(f($2)):3 t "Vesta cratering" w l lc palette z lw 2,\
  "../../dat/Marchi_etal_2012_HCT.dat" u 1:2 not                                 w lp lc '#ffffff' pt 7 ps 1.2,\
  "../../dat/Marchi_etal_2012_LDC.dat" u 1:2 not                                 w lp lc '#ffffff' pt 7 ps 1.2,\
  "../../dat/Marchi_etal_2012_HCT.dat" u 1:2 t "{/=14 Marchi etal. (2012), HTC}" w lp lc '#9999ff' pt 7 ps 0.8,\
  "../../dat/Marchi_etal_2012_LDC.dat" u 1:2 t "{/=14 LDC}"                      w lp lc '#bbbbff' pt 7 ps 0.8,\

#pa -1

set term post eps enh color dashed "Helvetica,18"
set out "craters_hist.eps"
set size 0.65,0.9
rep

system("eps2png craters_hist.eps")

q

#  "<awk '(FNR==1){ print \"\"; } { print $0,ARGIND; }' ../*[0-9]*/craters_hist/craters_hist.dat_hc" u 1:(f($2)):3 t "Vesta cratering" w l lc '#0066ff' lw 2,\
  "projects_hist.dat_hc" u 1:(f($2)) w l lt 0,\

