function varargout = wtbxmngr(option,varargin)
%WTBXMNGR Wavelet Toolbox version manager.
%   WTBXMNGR or WTBXMNGR('version') displays the current
%   version of the Toolbox mode (Version 1.x vs. 2.0).
% 
%   WTBXMNGR('V1') or WTBXMNGR('v1') sets the
%   wavelet packets management mode to Version 1.x
%   (This is the obsolete mode).
% 
%   WTBXMNGR('V2') or WTBXMNGR('v2') sets the
%   wavelet packets management mode to Version 2.0
%   The wavelet packets objects are used (see WPTREE).
%

% INTERNAL OPTIONS:
%-----------------
%   OPTION = 'load' , 'ini' , 'is_on' , 'get' , 'clear'

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 22-Feb-98.
%   Last Revision: 06-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.12 $  $Date: 2001/03/30 16:05:17 $

global WTBX_Glob_Info Wavelets_Info DWT_Attribute

%----------------------%
% Wavelets Structures. %
%------------------------------------------%
% WTBX_Glob_Info is a structure.
% WTBX_Glob_Info = ...
%   struct(...
%     'name'        char = 'WTBX'
%     'version'     integer
%     'objVersion'  integer
%     );
%------------------------------------------%
% Wavelets_Info is a  structure array 
% with size = [nb_fam 1]
%
% Wavelet_Struct =
%   struct(...
%     'index'           integer
%     'familyName'      string
%     'familyShortName' string
%     'type'            integer
%     'tabNums'         matrix of string
%     'typNums'         string
%     'file'            string
%     'bounds'          string
%     );
%------------------------------------------%
% DWT_Attribute is a structure.
%   struct(...
%     'extMode'   'sym' , 'zpd' , 'spd' ...
%     'shift1D'   integer
%     'shift2D'   [integer integer]
%     );
%------------------------------------------%

okInit = ...
    ~isempty(WTBX_Glob_Info) & ...
    ~isempty(Wavelets_Info)  & ...
    ~isempty(DWT_Attribute);

if nargin==0 , option = 'version'; end 
switch option
    case 'load'
      switch nargin
        case 1
          fileName = 'wtbx_gbl.v1';
          s = which(fileName,'-all');
          if ~isempty(s) ,
               VersfileName = 'wtbx_gbl.v1';
          else
               VersfileName = 'wtbx_gbl.v2';
          end
           
        case 2
          wtbxVER = varargin{1};
          switch wtbxVER
             case {'v1','V1'} , VersfileName = 'wtbx_gbl.v1';
             otherwise        , VersfileName = 'wtbx_gbl.v2';
          end
      end
      try
         load(VersfileName,'-mat');
      catch
         WTBX_Glob_Info.name       = 'WTBX';
         WTBX_Glob_Info.version    = 2.1;
         WTBX_Glob_Info.objVersion =   1;
      end
      if nargout>0
          varargout{1} = ['V' int2str(WTBX_Glob_Info.objVersion+1)];
      end

    case 'ini'
      if okInit , return; end
      wtbxmngr('load');
      wavemngr('load');
      dwtmode('load');

    case 'is_on'
      varargout{1} = okInit;

    case 'get'
      if ~okInit , wtbxmngr('ini'); end
      nbout   = nargout;
      nbin    = nargin-1;
      for k=1:min([nbin,nbout])
          switch varargin{k}
            case 'AppName'
              varargout{k} = [WTBX_Glob_Info.name '_V' ...
                              sprintf('%2.1f',WTBX_Glob_Info.version)];            
            case 'name'       , varargout{k} = WTBX_Glob_Info.name;            
            case 'version'    , varargout{k} = WTBX_Glob_Info.version;
            case 'objVersion' ,
              okObj = ~isempty(what('@wptree'));
              varargout{k} = WTBX_Glob_Info.objVersion & okObj;
            case 'wavelets'   , varargout{k} = Wavelets_Info;
            case 'dwtAttrb'   , varargout{k} = DWT_Attribute;
          end
      end

    case {'version'}
      objVers  = wtbxmngr('get','objVersion');
      wtbxVers = ['V' int2str(objVers+1)];
      if nargin<2 , dispMessage(wtbxVers); end
      if nargout>0 , varargout{1} = wtbxVers; end

    case {'v1','V1'}
      clear global WTBX_Glob_Info
      fileName = 'wtbx_gbl.v2';
      s = which(fileName);
      n = findstr(s,'wavedemo');
      addV1_path = [s(1:n-1) 'waveobsolete'];
      path(addV1_path,path);
      wtbxVers = wtbxmngr('load','V1');
      if nargin==1 , dispMessage(wtbxVers,'warning'); end
      if nargout>0 , varargout{1} = wtbxVers; end

    case {'v2','V2'}
      clear global WTBX_Glob_Info
      fileName = 'wtbx_gbl.v1';
      s = which(fileName,'-all');
      if ~isempty(s)
         for k = 1:size(s,1)
            d = s{k};
            n = findstr(d,fileName);
            rmpath(d(1:n-1));
         end
     end
     wtbxVers = wtbxmngr('load','V2');
     if nargin==1 , dispMessage(wtbxVers,'warning'); end
      if nargout>0 , varargout{1} = wtbxVers; end

    case 'clear'
      clear global WTBX_Glob_Info
      wavemngr('clear');
      dwtmode('clear');
end


%----------------------------------------------------------------------------%
% Internal Function(s)
%----------------------------------------------------------------------------%
function dispMessage(wtbxVers,dummy)

% Display Extension Mode.
msg = ['Wavelet Toolbox Version: V2'];
switch wtbxVers
    case {'v1','V1'}
       msg = strvcat(msg,...
          'The Wavelet Toolbox is now compatible with versions 1.x',...
          'Obsolete functions are now available.');
      
    case {'v2','V2'}

end
sizeMSG = size(msg);
nbLINES = sizeMSG(1);
lenMSG  = sizeMSG(2);
n = lenMSG+8;
b = '  ';
c = '*';
s = c(ones(1,n));
c  = c(ones(1,nbLINES),:); b  = b(ones(1,nbLINES),:);
msg1 = strvcat(' ',s,[c c b msg b c c],s,' ');

clc;
if nargin>1
    dummy  = '!  WARNING: Changed Wavelet Toolbox Version  !';
    lenDUM = length(dummy);
    addLEN = floor((lenMSG-lenDUM)/2);
    disp(' ');
    disp([blanks(addLEN), '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!']);
    disp([blanks(addLEN), '!  WARNING: Changed Wavelet Toolbox Version  !']);
    disp([blanks(addLEN), '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!']);
end

disp(msg1);
%----------------------------------------------------------------------------%
