function [out1,out2] = whelpfun(option,in2,in3,in4)
%WHELPFUN Help function.
%   [OUT1,OUT2] = WHELPFUN(OPTION,IN2,IN3,IN4)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 01-May-96.
%   Last Revision: 09-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.15 $

% Tag property of objects.
%------------------------
tag_fig_info = 'Whelpfig';
dy0 = 18;

switch option
    case {'movsli','movtxt','page_ud'} , fighelp = in2;
    otherwise
      fighelp = wfindobj('figure','tag',tag_fig_info);
end

if ~isempty(fighelp)
    fra    = findobj(fighelp,'style','frame');
    usr    = get(fra,'Userdata');
    txt    = usr(1:end-6);
    usr    = usr(end-5:end);
    btn_cl = usr(1);
    btn_p1 = usr(2);
    btn_p2 = usr(3);
    btn_p3 = usr(4);
    sli    = usr(5);
    axe    = usr(6);
end


switch option
    case 'movsli'
        val = round(get(sli,'Value'));
        usr = get(sli,'Userdata');
        if val==usr , return; end
        set(sli,'Value',val,'Userdata',val);
        dy  = -(val-usr)*dy0;
        whelpfun('movtxt',fighelp,dy);

    case 'movtxt'
        dy      = in3;
        old_u   = get(axe,'units');
        set([axe txt],'units','pixels');
        p_axe   = get(axe,'Position');
        dim     = length(txt);
        nbt_vis = floor(p_axe(4)/dy0)-1;
        nb_page = ceil(dim/nbt_vis);
        ena1 = 'off'; ena2 = 'off'; ena3 = 'off';
        for k = 1:dim
            p  = get(txt(k),'Position');
            p2 = p(2)+dy;
            p3 = p2+dy0;
            if (p2<dy0/2) | (p3>p_axe(4))
                vis = 'off';
                if k<=nbt_vis
                    ena1 = 'on';
                elseif (nbt_vis<k) & (k<=2*nbt_vis)
                    ena2 = 'on';
                else
                    ena3 = 'on';
                end
            else
                vis = 'on'; 
            end
            set(txt(k),'Position',[p(1) p2],'Visible',vis);
        end
        set(btn_p1,'Enable',ena1);
        set(btn_p2,'Enable',ena2);
        set(btn_p3,'Enable',ena3);    
        set([axe txt],'units',old_u);

    case 'page_ud'
        nump  = in3;
        old_u = get(axe,'units');
        set([axe txt(1)],'units','pixels');
        p_axe = get(axe,'Position');
        p_txt = get(txt(1),'Position');
        set([axe txt(1)],'units',old_u);
        switch nump
          case 1
            dy      = p_axe(4)-dy0-p_txt(2);
            vals    = get(sli,'Max');
          case 2
            nbt_vis = floor(p_axe(4)/dy0)-1;
            dy      = p_axe(4)-dy0-p_txt(2)+dy0*nbt_vis;
            vals    = get(sli,'Max')-nbt_vis;
          case 3
            nbt_vis = floor(p_axe(4)/dy0)-1;
            dy      = p_axe(4)-dy0-p_txt(2)+2*dy0*nbt_vis;
            vals    = get(sli,'Min');
        end
        set(sli,'Value',vals,'Userdata',vals);
        whelpfun('movtxt',fighelp,dy);

    case 'create'
        % Get Globals.
        %-------------
        [...
        ShiftTop_Fig,                           ...
        Def_Btn_Height,Def_Btn_Width,Y_Spacing, ...
        Def_TxtBkColor,Def_FraBkColor,Def_UicFtWeight] = ...
            mextglob('get',...
                'ShiftTop_Fig',                                     ...
                'Def_Btn_Height','Def_Btn_Width','Y_Spacing',       ...
                'Def_TxtBkColor','Def_FraBkColor','Def_UicFtWeight' ...
                );

        Deffontsize = get(0,'DefaultAxesFontSize');
        if nargin<3
            fname   = '';  
            fontsize = Deffontsize;
        elseif nargin<4
            fname = in3;
            fontsize = Deffontsize;
        else
            fname = in3;
            fontsize = in4;
        end
        fighelp = wfindobj('figure','tag',tag_fig_info);
        if isempty(fighelp)
            win_units   = 'pixels';
            Screen_Size = get(0,'ScreenSize');
            [nul,nul,win_height] = wfigmngr('figsizes');
            btn_width = 3*Def_Btn_Width/4;
            cmd_width = 2*btn_width;
            win_width = round(cmd_width/(1-0.85));
            pos_win   = [ Screen_Size(3)-5-win_width, ...
                          Screen_Size(4)-win_height-ShiftTop_Fig, ...
                          win_width, ...
                          win_height ...
                          ];
            axe_col = Def_TxtBkColor;
            fighelp = colordef('new','none');
            set(fighelp, ...
                  'MenuBar','none',...
                  'DefaultUicontrolBackgroundcolor',Def_FraBkColor,...
                  'DefaultUicontrolFontWeight', Def_UicFtWeight,...
                  'Name','Information window',...
                  'Visible','off',...
                  'Unit',win_units,...
                  'Position',pos_win,...
                  'Color',axe_col,...
                  'DefaultAxesXColor',axe_col,...
                  'DefaultAxesYColor',axe_col,...
                  'DefaultAxesZColor',axe_col,...
                  'NumberTitle','off',...
                  'Tag',tag_fig_info...
                  );
			wfigmngr('extfig',fighelp,'ExtFig_WH');

            x_fra   = pos_win(3)-cmd_width+1;
            w_fra   = cmd_width;
            pos_fra = [x_fra , 0 , w_fra , pos_win(4)+5];

            ypos       = pos_fra(2)+pos_fra(4)-5*Def_Btn_Height;
            pos_close  = [ x_fra+btn_width/4 ,...
                           ypos                 ,...
                           3*btn_width/2        ,...
                           2*Def_Btn_Height     ];

            ypos       = ypos-pos_close(4)-2*Def_Btn_Height;
            pos_btn_p1 = pos_close;  pos_btn_p1(2) = ypos;
            ypos       = ypos-pos_close(4)-2*Def_Btn_Height;
            pos_btn_p2 = pos_close;  pos_btn_p2(2) = ypos;
            ypos       = ypos-pos_close(4)-2*Def_Btn_Height;
            pos_btn_p3 = pos_close;  pos_btn_p3(2) = ypos;

            str_close  = 'Close';
            str_btn_p1 = 'Page 1';
            str_btn_p2 = 'Page 2';
            str_btn_p3 = 'Page 3';
            figStr     = sprintf('%.0f',fighelp);
            cba_close  = [mfilename '(''close'',' figStr ');'];
            cba_btn_p1 = [mfilename '(''page_ud'',' figStr ',1);'];
            cba_btn_p2 = [mfilename '(''page_ud'',' figStr ',2);'];
            cba_btn_p3 = [mfilename '(''page_ud'',' figStr ',3);'];

            commonProp = {...
               'Parent',fighelp, ...
               'Visible','off',  ...
               'Unit',win_units  ...
               };
            fra  = uicontrol(...
                             'Parent',fighelp,   ...
                             'Style','frame',    ...
                             'Visible','off',    ...
                             'Unit',win_units,   ...
                             'Position',pos_fra, ...
                             'Backgroundcolor',Def_FraBkColor...
                            );

            btn_cl = uicontrol(...
                               'Parent',fighelp,     ...
                               'Style','Pushbutton', ...
                               'Unit',win_units,     ...
                               'Visible','off',      ...
                               'Position',pos_close, ...
                               'String',str_close,   ...
                               'Interruptible','on', ...
                               'Callback',cba_close  ...
                               );
            set(fighelp,'CloseRequestFcn',cba_close)

            btn_p1 = uicontrol(...
                               'Parent',fighelp,     ...
                               'Style','Pushbutton', ...
                               'Unit',win_units,     ...
                               'Visible','off',      ...
                               'Position',pos_btn_p1,...
                               'String',str_btn_p1,  ...
                               'Interruptible','on', ...
                               'Callback',cba_btn_p1 ...
                               );

            btn_p2 = uicontrol(...
                               'Parent',fighelp,     ...
                               'Style','Pushbutton', ...
                               'Unit',win_units,     ...
                               'Visible','off',      ...
                               'Position',pos_btn_p2,...
                               'String',str_btn_p2,  ...
                               'Interruptible','on', ...
                               'Callback',cba_btn_p2 ...
                               );

            btn_p3 = uicontrol(...
                               'Parent',fighelp,     ...
                               'Style','Pushbutton', ...
                               'Unit',win_units,     ...
                               'Visible','off',      ...
                               'Position',pos_btn_p3,...
                               'String',str_btn_p3,  ...
                               'Interruptible','on', ...
                               'Callback',cba_btn_p3 ...
                               );

            p_axe  = [0 0 win_width-cmd_width win_height];
            axe    = axes(...
                          'Parent',fighelp,               ...
                          'Visible','off',                ...
                          'Units','pixels',               ...
                          'Position',p_axe,               ...
                          'DrawMode','Fast',              ...
                          'XTicklabelMode','manual',      ...
                          'YTicklabelMode','manual',      ...
                          'XTickLabel',[],'YTickLabel',[],...
                          'Box','On',                     ...
                          'XGrid','off','YGrid','off',    ...
                          'color',axe_col                 ...
                         );
            pos_sli = [p_axe(1)+p_axe(3)-15 p_axe(2) 15 p_axe(4)];
            cba_sli = [mfilename '(''movsli'',' sprintf('%.0f',fighelp) ');'];
            sli     = uicontrol(...
                                'Parent',fighelp,   ...
                                'style','slider',   ...
                                'Units','pixels',   ...
                                'Position',pos_sli, ...
                                'Visible','off',    ...
                                'Min',0,            ...
                                'Max',150,          ...
                                'Value',150,        ...
                                'Callback',cba_sli  ...
                                 );
            set([fighelp,fra,btn_cl,btn_p1,btn_p2,btn_p3,sli,axe], ...
                                    'units','normalized');
            set([fighelp,fra,btn_cl,axe,sli],'Visible','on');
            drawnow
        else
            old_name = get(btn_cl,'Userdata');
            if ~isempty(old_name) & strcmp(old_name,fname) , return; end
            delete(txt);
            set([sli,btn_p1,btn_p2,btn_p3],'Visible','off');
            if ~isequal(get(0,'CurrentFigure'),fighelp) , figure(fighelp); end
        end
        set(fighelp,'Name',['Information window : ' in2(1,:)]);
        set(fra,'Userdata',[btn_cl,btn_p1,btn_p2,btn_p3,sli,axe]);
        set(btn_cl,'Userdata',fname);
        dim     = size(in2,1);
        old_u   = get(axe,'units');
        set(axe,'units','pixels');
        txt_col = [0 0 0];
        p_axe   = get(axe,'Position');
        dy      = dy0;
        dx      = 20;
        y1      = p_axe(4);
        nbt_vis = floor(y1/dy0)-1;
        nb_page = ceil(dim/nbt_vis);
        invis   = 0;
        txt     = zeros(1,dim);

        I124 = find(in2=='|');
        car = '!';
        in2(I124) = car(ones(size(I124)));

        for k = 1:dim
            y1 = y1-dy;
            if y1<dy0/2 , invis = invis+1; end
            txt(k) = text(dx,y1,in2(k,:),           ...
                          'units','pixels',     ...
                          'fontname','courier', ...
                          'fontsize',fontsize,  ...
                          'Color',txt_col,      ...
                          'Visible','off',      ...
                          'Userdata',k,         ...
                          'Parent',axe          ...
                          );
        end
        if dim-invis>0 , set(txt(1:dim-invis),'Visible','on'); end
     
        set(axe,'units',old_u);
        if nb_page>1
            set(btn_p1,'Visible','on','Enable','off');
            set(btn_p2,'Visible','on','Enable','on');
            if nb_page>2, set(btn_p3,'Visible','on','Enable','on'); end
            val = (nb_page-1)*nbt_vis;
            set(sli,...
                  'Units','pixels',             ...
                  'Max',val,'Value',val,        ...
                  'Userdata',val,'Visible','on' ...
                  );
        else
            set(sli,'Visible','off')
        end
        set([txt sli],'units','normalized');
        set(fra,'Userdata',[txt get(fra,'Userdata')]);

    case 'getflag'
        out1 = [];
        out2 = fighelp;
        if isempty(fighelp) , return; end
        out1 = get(btn_cl,'Userdata');

    case 'close'
        delete(in2)
end
