function varargout = wguidiv(option,varargin)
%WGUIDIV Test inputs for different "TOOLS" files.
%   VARARGOUT = WGUIDIV(OPTION,VARARGIN)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-May-98.
%   Last Revision: 12-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:04:34 $

switch option

  case 'WTB_DemoPath'
    testfile = varargin{1};
    % pathname = fullfile(matlabroot,'toolbox','wavelet','wavedemo');
    dum = which('dguicf1d.m','-all');
    pathname = fileparts(dum{1});
    pathname = which([pathname filesep testfile]);
    if ~isempty(pathname)
        ind = findstr(pathname,testfile);
        pathname = pathname(1:ind-1);
    end
    varargout{1} = pathname;       

  case 'load_wpdec'
    fig  = varargin{1};
    mask = varargin{2};
    txt  = varargin{3};
    ord  = varargin{4};
    [filename,pathname,ok] = utguidiv('test_load',fig,mask,txt);
    if ok
        wwaiting('msg',fig,'Wait ... loading');
        fullName = fullfile(pathname,filename);
        try
          err = 0;
          load(fullName,'-mat');
          if ~exist('tree_struct','var')
              err = 1; var = 'tree_struct';
          elseif ~exist('data_struct','var')
              if ~isa(tree_struct,'wptree')
                  err = 1; var = 'data_struct';
              end
          end
          if ~err
              err = ~isequal(ord,treeord(tree_struct));
              if err
                  msg = strvcat(['The decomposition is not a ' ...
                          int2str(ord) ' dimensional analysis'],' ');
              end
          else
              msg = ['variable : ' var ' , not found !'];
          end
        catch
          err = 1;
          msg = ['File ' filename ' is not a valid file.'];
        end
        if err
           wwaiting('off',fig);
           errordlg(msg,'Load ERROR','modal');
           ok = 0;
        end
    end
    varargout = {filename,pathname,ok};

end
