function y = wconv(type,x,f)
%WCONV  1-D or 2-D Convolution.
%   Y = WCONV(TYPE,X,F) performs the 1-D or 2-D
%   convolution of X and F.
%
%   Y = WCONV(TYPE,X,F) with TYPE = {1,'1','1d' or '1D'}
%   and if X and F are vectors, performs the 1-D 
%   convolution of X and F.
%    
%   Y = WCONV(TYPE,X,F) with TYPE = {2,'2','2d' or '2D'}
%   and if X and F are matrices, performs the 2-D 
%   convolution of X and F.
%
%   Y = WCONV('r',X,F) or Y = WCONV('row',X,F)
%   if X is a matrix and F a vector, performs 
%   the 1-D convolution of the rows of X and F.
%
%   Y = WCONV('c',X,F) or Y = WCONV('col',X,F)
%   if X is a matrix and F a vector, performs 
%   the 1-D convolution of the columns of X and F.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 15-Nov-97.
%   Last Revision: 01-May-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.8 $  $Date: 2001/03/30 16:04:22 $

% Check arguments.
if errargn(mfilename,nargin,[3],nargout,[0:1]), error('*'), end

switch type
    case {1,'1','1d','1D'}
        y = conv2(x(:)',f(:)'); if size(x,1)>1 , y = y'; end
 
    case {2,'2','2d','2D'}, y = conv2(x,f);
    case {'r','row'}, y = conv2(x,f(:)');
    case {'c','col'}, y = conv2(x',f(:)'); y = y';
end
