function y = wcodemat(x,nb,opt,absol)
%WCODEMAT Extended pseudocolor matrix scaling.
%   Y = WCODEMAT(X,NBCODES,OPT,ABSOL) returns a coded version
%   of input matrix X if ABSOL=0, or ABS(X) if ABSOL is 
%   nonzero, using the first NBCODES integers.
%   Coding can be done row-wise (OPT='row' or 'r'), columnwise 
%   (OPT='col' or 'c'), or globally (OPT='mat' or 'm'). 
%   Coding uses a regular grid between the minimum and 
%   the maximum values of each row (column or matrix,
%   respectively).
%
%   Y = WCODEMAT(X,NBCODES,OPT) is equivalent to
%   Y = WCODEMAT(X,NBCODES,OPT,1).
%   Y = WCODEMAT(X,NBCODES) is equivalent to
%   Y = WCODEMAT(X,NBCODES,'mat',1).
%   Y = WCODEMAT(X) is equivalent to
%   Y = WCODEMAT(X,16,'mat',1).

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 01-May-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.10 $

% Check arguments.
if errargn(mfilename,nargin,[1:4],nargout,[0 1]), error('*'), end

switch nargin
    case 1 , absol = 1; opt = 'mat'; nb = 16;
    case 2 , absol = 1; opt = 'mat';
    case 3 , absol = 1;
end
opt = lower(opt);

trans = 0;
if isequal(opt,'row') | isequal(opt,'r')
    trans = 1;
    opt   = 'col';
    x     = x';
end
[t1,t2] = size(x);
y       = ones(t1,t2);
if absol , x = abs(x); end
switch opt
    case {'mat','m'}
        x = x - min(min(x));
        maxx  = max(max(x));
        if maxx<eps , return; end
        mul  = nb/maxx;
        y(:) = fix(1 + mul*x);

    case {'col','c'}
        minx  = min(x); 
        x = (x - minx(ones(1,t1),:));
        maxx  = max(x);
        echel = maxx(ones(1,t1),:);
        echel = echel(:);
        indexs = find(echel>eps);
        y(indexs) = fix(y(indexs) + nb*x(indexs)./echel(indexs));

    otherwise
        error(['*** ' mfilename ' : Unknown Option ***']);
end
y(y>nb) = nb;
if trans, y = y'; end

