function wavemenu(option,varargin)
%WAVEMENU Start the Wavelet Toolbox graphical user interface tools.
%   WAVEMENU launches a menu for accessing the various 
%   graphical tools provided in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 13-Jan-2001.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.19 $ $Date: 2001/03/30 16:04:14 $

% Tag.
%------
tag_wav_tool = 'Wave_Tool';

win_wavemenu = wfindobj('figure','tag',tag_wav_tool);
init = 0;
if nargin==0
    option = 'create';
elseif nargin==1
    if ~ischar(option)
        winAttrb = option; init = 1; option = 'create';
    elseif isempty(option)
        winAttrb = [];     init = 1; option = 'create';
    elseif strcmp(option(1),'m')
        winAttrb = 'mono'; init = 1; option = 'create';
    elseif strcmp(option,'pref')
        winAttrb = [];     init = 1; option = 'create';
    end
else
    winAttrb = varargin{1};
    if ~strcmp(option,'close') , init = 1; option = 'create'; end
end

switch option
    case 'create'
        if ~isempty(win_wavemenu) , return; end
        if init
            initGlobals('pref',winAttrb); 
        else
            initGlobals('ini',[]);
        end

        % Globals initialization.
        %-------------------------
        [InitMode,ShiftTop_Fig,Def_Btn_Height,Def_Btn_Width] = ...
            mextglob('get','InitMode' ,'ShiftTop_Fig', ...
            'Def_Btn_Height','Def_Btn_Width');
        
        switch InitMode
          case 1 ,
            figMenuColor = [0 0 0];
            txtFgColor   = [1 1 0];
            fraFgColor   = txtFgColor;

          otherwise
            figMenuColor = [0.8 0.8 0.8];
            txtFgColor   = [0 0 1];
            fraFgColor   = [0 0 0];
        end
        txtBgColor = figMenuColor;
        fraBgColor = figMenuColor;

        % Waiting Frame construction & begin waiting.
        %--------------------------------------------
        mousefrm(0,'watch');

        % Wavelet main window initialization.
        %------------------------------------
        win_units   = 'pixels';
        Screen_Size = get(0,'ScreenSize');
        x_unit      = Def_Btn_Width/8;
        y_unit      = Def_Btn_Height/2;
        btn_width   = 22*x_unit;
        bdx         = x_unit;
        bdy         = y_unit;
        mulY        = 2.5;
        btn_heigth  = 3*y_unit;
        if Screen_Size(3)<900
            btn_width = 24*x_unit;
            mulY      = 3;
        end
        btn_left   = 2*bdx;
        fra_left   = bdx;
        fra_width  = btn_width+2*bdx;
        dif_heigth = btn_heigth+0*y_unit;
        win_width  = 2*fra_width+6*bdx;

        % Position property of objects.
        %------------------------------
        btn_low   = 2*bdy;
        w_uic     = 18*x_unit;
        x_uic     = (win_width-w_uic)/2;
        pos_close = [x_uic, btn_low , w_uic , btn_heigth];

        % Left side.
        %-----------
        countAllBtn = 0;
        countBtn  = 0;
        fra_low   = pos_close(2)+pos_close(4)+2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_wpdi  = [btn_left, btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_wvdi  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra3  = [fra_left, fra_low, fra_width, h_fra];
	
		txt3_heigth = btn_heigth/2;
        txt3_width  = btn_width/3;
        txt3_low    = (fra_low + h_fra) - (txt3_heigth/2);
        txt3_left   = fra_left + (fra_width - txt3_width)/2;
        pos_txt3    = [txt3_left, txt3_low, txt3_width, txt3_heigth];
	
        countAllBtn = countAllBtn+countBtn;
        countBtn  = 0;
        fra_low   = pos_fra3(2)+pos_fra3(4)+ 2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_wp2d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_dw2d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra2  = [fra_left, fra_low, fra_width, h_fra];
	
        txt2_heigth = btn_heigth/2;
        txt2_width  = btn_width*(1/2+1/6);
        txt2_low    = (fra_low + h_fra) - (txt2_heigth/2);
        txt2_left   = fra_left + (fra_width - txt2_width)/2;
        pos_txt2    = [txt2_left, txt2_low, txt2_width, txt2_heigth];
	
        countAllBtn = countAllBtn+countBtn;
        countBtn  = 0;
        fra_low   = pos_fra2(2)+pos_fra2(4)+ 2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_cwim  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_cw1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_wp1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_dw1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra1  = [fra_left, fra_low, fra_width, h_fra];
	
	    txt1_heigth = btn_heigth/2;
	    txt1_width  = btn_width*(1/2+1/6);
	    txt1_low    = (fra_low + h_fra) - (txt1_heigth/2);
	    txt1_left   = fra_left + (fra_width - txt1_width)/2;
        pos_txt1    = [txt1_left, txt1_low, txt1_width, txt1_heigth];

        % Right side.
        %------------
        transX   = fra_width+4*x_unit;
        transPOS = [transX 0 0 0];        
        pos_fra4 = pos_fra1 + transPOS;
        pos_fra5 = pos_fra2 + transPOS;
        pos_fra6 = pos_fra3 + transPOS;        
        pos_txt4 = pos_txt1 + transPOS;
        add_wid  = (0*btn_width)/6;
        pos_txt4 = pos_txt4 + add_wid*[-0.5,0,1,0];
        pos_txt5 = pos_txt2 + transPOS;
        pos_txt5 = pos_txt5 + add_wid*[-0.5,0,1,0];
        pos_txt6 = pos_txt3 + transPOS;        
        pos_sw1d = pos_dw1d + transPOS;
        pos_dens = pos_wp1d + transPOS;
        pos_regr = pos_cw1d + transPOS;
        pos_cf1d = pos_cwim + transPOS;
        pos_sw2d = pos_dw2d + transPOS;
        pos_cf2d = pos_wp2d + transPOS;
        pos_sext = pos_wvdi + transPOS;
        pos_iext = pos_wpdi + transPOS;

        % Window.
        %--------
        win_width  = 2*fra_width+6*bdx;
	    win_height = pos_fra1(4)+pos_fra2(4)+pos_fra3(4)+ ...
                     10*bdy+pos_close(4);
        pos_win    = [Screen_Size(3)*0.01, ...
                      Screen_Size(4)-win_height-3*ShiftTop_Fig/2, ...
                      win_width, ...
                      win_height ...
                      ];
        figName    = 'Wavelet Toolbox Main Menu ';
        win_wavemenu = wfigmngr('init',         ...
                          'Name',figName,       ...
                          'Unit',win_units,     ...
                          'Position',pos_win,   ...
                          'Visible','Off',      ...
                          'Tag',tag_wav_tool,   ...
                          'Color',figMenuColor  ...
                          );
		wfigmngr('extfig',win_wavemenu,'ExtMainFig_WTBX');						  
        set(win_wavemenu,'Visible','On');
	
        % String property of objects.
        %----------------------------
        str_dw1d = 'Wavelet 1-D';
        str_wp1d = 'Wavelet Packet 1-D';
        str_cw1d = 'Continuous Wavelet 1-D';
        str_cwim = 'Complex Continuous Wavelet 1-D';
        str_dw2d = 'Wavelet 2-D';
        str_wp2d = 'Wavelet Packet 2-D';
        str_wvdi = 'Wavelet Display';
        str_wpdi = 'Wavelet Packet Display';
        str_sw1d = 'SWT De-noising 1-D';
        str_dens = 'Density Estimation 1-D';
        str_regr = 'Regression Estimation 1-D';
        str_cf1d = 'Wavelet Coefficients Selection 1-D';
        str_sw2d = 'SWT De-noising 2-D';
        str_cf2d = 'Wavelet Coefficients Selection 2-D';
        str_sext = 'Signal Extension';
        str_iext = 'Image Extension';
        str_close= 'Close';
	    str_fra1 = 'One-Dimensional';
	    str_fra2 = 'Two-Dimensional';
	    str_fra3 = 'Display';
	    str_fra4 = 'Specialized Tools 1-D';
	    str_fra5 = 'Specialized Tools 2-D';
	    str_fra6 = 'Extension';
	
        % Callback property of objects.
        %------------------------------
        mouseStr  = 'mousefrm(0,''watch'');';
        cba_dw1d  = [mouseStr 'eval(''dw1dtool;'')'];
        cba_wp1d  = [mouseStr 'eval(''wp1dtool;'')'];
        cba_cw1d  = [mouseStr 'eval(''cw1dtool;'')'];
        cba_cwim  = [mouseStr 'eval(''cwimtool;'')'];
        cba_dw2d  = [mouseStr 'eval(''dw2dtool;'')'];
        cba_wp2d  = [mouseStr 'eval(''wp2dtool;'')'];
        cba_wvdi  = [mouseStr 'eval(''wvdtool;'')'];
        cba_wpdi  = [mouseStr 'eval(''wpdtool;'')'];
        cba_sw1d  = [mouseStr 'eval(''sw1dtool;'')'];
        cba_dens  = [mouseStr 'eval(''de1dtool;'')'];
        cba_regr  = [mouseStr 'eval(''re1dtool;'')'];
        cba_cf1d  = [mouseStr 'eval(''cf1dtool;'')'];
        cba_sw2d  = [mouseStr 'eval(''sw2dtool;'')'];
        cba_cf2d  = [mouseStr 'eval(''cf2dtool;'')'];
        cba_sext  = [mouseStr 'eval(''sigxtool;'')'];
        cba_iext  = [mouseStr 'eval(''imgxtool;'')'];
        cba_close = [mouseStr mfilename '(''close'');'];

        % Construction of objects.
        %-------------------------
        commonProp = {'Parent',win_wavemenu,'Unit',win_units};
        comFraProp = {commonProp{:},'Style','frame',...
             'ForeGroundColor',fraFgColor,'BackGroundColor',fraBgColor};
        comPusProp = {commonProp{:},'Style','Pushbutton'};
        comTxtProp = {commonProp{:},'Style','Text', ...
            'ForeGroundColor',txtFgColor,'BackGroundColor',txtBgColor};

        fra1 = uicontrol(comFraProp{:},'Position',pos_fra1);
        fra2 = uicontrol(comFraProp{:},'Position',pos_fra2);
        fra3 = uicontrol(comFraProp{:},'Position',pos_fra3);
        fra4 = uicontrol(comFraProp{:},'Position',pos_fra4);
        fra5 = uicontrol(comFraProp{:},'Position',pos_fra5);
        fra6 = uicontrol(comFraProp{:},'Position',pos_fra6);

        txt_fra1 = uicontrol(comTxtProp{:},'Position',pos_txt1,...
                             	'String',str_fra1);
        txt_fra2 = uicontrol(comTxtProp{:},'Position',pos_txt2,...
                             	'String',str_fra2);
        txt_fra3 = uicontrol(comTxtProp{:},'Position',pos_txt3,...
                             	'String',str_fra3);
        txt_fra4 = uicontrol(comTxtProp{:},'Position',pos_txt4,...
                             	'String',str_fra4);
        txt_fra5 = uicontrol(comTxtProp{:},'Position',pos_txt5,...
                             	'String',str_fra5);
        txt_fra6 = uicontrol(comTxtProp{:},'Position',pos_txt6,...
                             	'String',str_fra6);

        toolTip  = 'One-Dimensional Discrete Wavelet Analysis Tool';
        pus_dw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_dw1d,...
                             'String',str_dw1d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_dw1d...
                             );

		toolTip  = 'One-Dimensional Discrete Wavelet Packet Analysis Tool';
        pus_wp1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_wp1d,...
                             'String',str_wp1d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_wp1d...
                             );

        toolTip  = 'One-Dimensional Continuous Wavelet Analysis Tool';
        pus_cw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cw1d,...
                             'String',str_cw1d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_cw1d...
                             );

        toolTip  = 'One-Dimensional Continuous Wavelet (Complex Case) Analysis Tool';
        pus_cwim = uicontrol(comPusProp{:}, ...
                             'Position',pos_cwim,...
                             'String',str_cwim,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_cwim...
                             );

        toolTip  = 'Two-Dimensional Discrete Wavelet Analysis Tool';
        pus_dw2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_dw2d,...
                             'String',str_dw2d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_dw2d...
                             );

        toolTip  = 'Two-Dimensional Discrete Wavelet Packet Analysis Tool';
        pus_wp2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_wp2d,...
                             'String',str_wp2d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_wp2d...
                             );

        toolTip  = 'Wavelet Display Tool';
        pus_wvdi = uicontrol(comPusProp{:}, ...
                             'Position',pos_wvdi,...
                             'String',str_wvdi,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_wvdi...
                             );

        toolTip  = 'Wavelet Packet Display Tool';
        pus_wpdi = uicontrol(comPusProp{:}, ...
                             'Position',pos_wpdi,...
                             'String',str_wpdi,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_wpdi...
                             );

        toolTip  = 'One-Dimensional Stationary Wavelet Analysis Tool';
        pus_sw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_sw1d,...
                             'String',str_sw1d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_sw1d...
                             );

        toolTip  = 'One-Dimensional Density Estimation Tool';			     
        pus_dens = uicontrol(comPusProp{:}, ...
                             'Position',pos_dens,...
                             'String',str_dens,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_dens...
                             );

        toolTip  = 'One-Dimensional Regression Estimation Tool';
        pus_regr = uicontrol(comPusProp{:}, ...
                             'Position',pos_regr,...
                             'String',str_regr,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_regr...
                             );

        toolTip  = 'One-Dimensional Wavelet Coefficient Selection Tool';
        pus_cf1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cf1d,...
                             'String',str_cf1d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_cf1d...
                             );

        toolTip  = 'Two-Dimensional Stationary Wavelet Analysis Tool';
        pus_sw2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_sw2d,...
                             'String',str_sw2d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_sw2d...
                             );

        toolTip  = 'Two-Dimensional Wavelet Coefficient Selection Tool';
        pus_cf2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cf2d,...
                             'String',str_cf2d,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_cf2d...
                             );

        toolTip  = 'One-Dimensional Signal Extension and Truncation Tool';
        pus_sext = uicontrol(comPusProp{:}, ...
                             'Position',pos_sext,...
                             'String',str_sext,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_sext...
                             );

        toolTip  = 'Two-Dimensional Image Extension and Truncation Tool';
        pus_iext = uicontrol(comPusProp{:}, ...
                             'Position',pos_iext,...
                             'String',str_iext,...
                             'ToolTipString',toolTip,...
                             'Callback',cba_iext...
                             );

        pus_close = uicontrol(comPusProp{:}, ...
                              'Position',pos_close,...
                              'String',str_close,...
                              'ToolTipString','Exit the Wavelet Toolbox Main Menu',...
                              'Callback',cba_close...
                              );

		% Add Context Sensitive Help (CSHelp).
		%-------------------------------------
		wfighelp('add_ContextMenu',win_wavemenu,pus_dw1d,'DW1D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_wp1d,'WP1D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_cw1d,'CW1D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_cwim,'CWIM_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_dw2d,'DW2D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_wp2d,'WP2D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_wvdi,'WVDI_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_wpdi,'WPDI_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_sw1d,'SW1D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_dens,'EDEN_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_regr,'REGF_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_cf1d,'CF1D_GUI');
		wfighelp('add_ContextMenu',win_wavemenu,pus_sw2d,'SW2D_GUI');		
		wfighelp('add_ContextMenu',win_wavemenu,pus_cf2d,'CF2D_GUI');		
		wfighelp('add_ContextMenu',win_wavemenu,pus_sext,'SIGX_GUI');		
		wfighelp('add_ContextMenu',win_wavemenu,pus_iext,'IMGX_GUI');		
		%-------------------------------------

        % Prevent OS closing.
        %--------------------
        set(win_wavemenu,'CloseRequestFcn',cba_close)

        % Setting units to normalized.
        %-----------------------------
        set(findobj(win_wavemenu,'Units','pixels'),'Units','Normalized');
        hidegui(win_wavemenu,'off');

        % End waiting.
        %---------------
        mousefrm(0,'arrow');

    case 'close'
        % Closing all opened main analysis windows.
        %------------------------------------------
        fig = gcbf;
        wfigmngr('close',fig);
        
        % Closing the wavemenu window.
        %-----------------------------
        try, delete(fig); end
        mextglob('clear');
        wtbxmngr('clear');
        mousefrm(0,'arrow');

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end


function initGlobals(option,pref)
%initGlobals Initialization of some globals variables.
%   initGlobals(OPTION,IN2)

if ~wtbxmngr('is_on') , wtbxmngr('ini'); end
if ~(isempty(pref) & mextglob('is_on')) , mextglob(option,pref); end

