function varargout = utguidiv(option,varargin)
%UTGUIDIV Utilities for testing inputs for different "TOOLS" files.
%   VARARGOUT = UTGUIDIV(OPTION,VARARGIN)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-May-98.
%   Last Revision: 02-Aug-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:04:03 $

switch option
  case 'ini'
    winAttrb = [];
    optval   = varargin{1};
    switch nargin
      case 2
        if ~ischar(optval)
            winAttrb = optval; optval = 'create';
        end
      otherwise
        if isequal(optval,'create') ,  winAttrb = varargin{2}; end
    end
    varargout = {optval,winAttrb};

  case {'test_load','test_save'}
    fig  = varargin{1};
    mask = varargin{2};
    txt  = varargin{3};
    [xpos,ypos] = wfigutil('left_up',fig,10,30);
    switch option
      case 'test_load', [filename,pathname] = uigetfile(mask,txt,xpos,ypos);
      case 'test_save'
        [filename,pathname] = uiputfile(mask,txt,xpos,ypos);
        try
          [name,ext] = strtok(filename,'.');
          eval([name ' = 0;'])
        catch
          filename = 0;
        end
    end
    if isempty(filename) | filename==0 , ok = 0;
    else , ok = 1;
    end
    varargout = {filename,pathname,ok};

  case {'load_sig','load_dem1D'}
    fig  = varargin{1};
    switch option
      case 'load_sig'       
        mask = varargin{2};
        txt  = varargin{3};
        [filename,pathname,ok] = utguidiv('test_load',fig,mask,txt);

      case 'load_dem1D'
        pathname = varargin{2};
        filename = varargin{3};
        ok = 1;
    end

    % default.
    %---------
    sigInfos = struct(...
       'pathname',pathname, ...
       'filename',filename, ...
       'name','',     ...
       'size',0       ...
       );
    sig_Anal = [];

    if ok
       wwaiting('msg',fig,'Wait ... loading');
       fullName = fullfile(sigInfos.pathname,sigInfos.filename);
       [fileStruct,err] = wfileinf(fullName);
       if ~err
           err = 1;
           for k = 1:length(fileStruct)
               if isequal(fileStruct(k).class,'double')
                   siz = fileStruct(k).size;
                   if min(siz)==1 & max(siz)>1
                       err = 0;
                       sigInfos.name = fileStruct(k).name;
                       break
                   end
               end
           end
           if ~err
               try
                 load(fullName,'-mat');
                 sig_Anal = eval(sigInfos.name);
                 if size(sig_Anal,1)>1 , sig_Anal = sig_Anal'; end
                 sigInfos.size = length(sig_Anal);

               catch
                 err = 1;
                 msg = ['File ' sigInfos.filename ' is not a valid file.'];
               end

           else
               msg = strvcat(['File ' sigInfos.filename ...
                        ' doesn''t contain one dimensional Signal.'],' ');
           end
       else
           msg = strvcat(['File ' sigInfos.filename ...
                          ' is not a valid file or is empty.'],' ');
       end
       ok = ~err;
       if err
           wwaiting('off',fig);
           errordlg(msg,'Load Signal ERROR','modal');
       end
    end
    varargout = {sigInfos,sig_Anal,ok};

  case {'load_img','load_dem2D'}
    fig  = varargin{1}; 
    switch option
      case 'load_img'       
        mask = varargin{2};
        txt  = varargin{3};
        [filename,pathname,ok] = utguidiv('test_load',fig,mask,txt);

      case 'load_dem2D'
        pathname = varargin{2};
        filename = varargin{3};
        ok = 1;
    end
    default_nbcolors = varargin{4};

    % default.
    %---------
    imgInfos = struct(...
       'pathname',pathname,  ...    
       'filename',filename,  ...
       'name','',      ...
       'true_name','', ...
       'type','mat',   ...
       'self_map',0,   ...
       'size',[0 0]    ...
       );
    X = []; map = [];

    if ok
         wwaiting('msg',fig,'Wait ... loading');
	 fullName = fullfile(imgInfos.pathname,imgInfos.filename);
         [fileStruct,err] = wfileinf(fullName);
	 [imgInfos.name,ext] = strtok(imgInfos.filename,'.');
         if ~isempty(ext) , ext = ext(2:end); end
         if ~err
            err = 1;
            for k = 1:length(fileStruct)
                mm = min(fileStruct(k).size);
                if mm>3
                    err = 0;
		    imgInfos.true_name = fileStruct(k).name;
                    break
                end
            end
            if err
                numMsg = 2;
            else
                try
                  load(fullName,'-mat');
		  imgInfos.type = 'mat';
		  X = eval(imgInfos.true_name);
                catch
                  err = 1; numMsg = 1;
                end
            end
         else
            numMsg = 1;
            try 
              switch ext
                case {'bmp','hdf','jpg','jpeg','pcx','tif','tiff'}
                   [info,msginfo] = imfinfo(fullName,ext);
                otherwise
                   [info,msginfo] = imfinfo(fullName);
              end
              imgInfos.type  = info.Format;
              colorType = lower(info.ColorType);
              switch colorType
                case {'rgb','truecolor'}
                case {'indexed','grayscale'}
                  [X,map] = imread(fullName,ext);
                  X       = double(X);
                  mi      = min(min(X));
                  if mi<1 , X = X-mi+1; end
                  if isempty(map)
                      ma  = max(max(X));
                      map = pink(ma);
                      X   = wcodemat(X,ma);
                  end
                  [dummy,name,ext,dummy] = fileparts(filename);
                  Img_True_Name = 'X';
                  imgInfos.name = [name,ext];
                  imgInfos.true_name = 'X';
                  err = 0;
              end               
            end
        end
        ok = ~err;
        if err
            switch numMsg
              case 1
                msg = strvcat(...
			['File ' imgInfos.filename ' is not a valid file' ...
                         ' or is empty.'],' ');
              case 2
                msg = strvcat(...
			['File ' imgInfos.filename ' doesn''t contain' ...
                         ' an Image.'],' ');

            end
            wwaiting('off',fig);
	    errordlg(msg,'Load Image ERROR','modal');
	else
	    imgInfos.self_map = ~isempty(map);
	    if ~imgInfos.self_map
                mi = round(min(min(X)));
                ma = round(max(max(X)));
                if mi<=0 , ma = ma-mi+1; end
		ma  = min([default_nbcolors,max([2,ma])]);
                map = pink(ma);
	    end
	    imgInfos.size = fliplr(size(X));
        end
    end
    varargout = {imgInfos,X,map,ok};

  case 'load_var'
    fig  = varargin{1};
    mask = varargin{2};
    txt  = varargin{3};
    vars = varargin{4};
    [filename,pathname,ok] = utguidiv('test_load',fig,mask,txt);
    if ok
        wwaiting('msg',fig,'Wait ... loading');
        try
          err = 0;
          load([pathname filename],'-mat');
          for k = 1:length(vars)
              var = vars{k};
              if ~exist(vars{k},'var') , err = 1; break; end
          end
          if err , msg = ['variable : ' var ' , not found !']; end
        catch
          err = 1;
          msg = ['File ' filename ' is not a valid file.'];
        end
        if err
           wwaiting('off',fig);
           errordlg(msg,'Load ERROR','modal');
           ok = 0;
        end
    end
    varargout = {filename,pathname,ok};

end


