function varargout = utcolmap(option,fig,varargin)
%UTCOLMAP Wavelet colormap utilities.
%   VARARGOUT = UTCOLMAP(OPTION,FIG,VARARGIN)
%   option = 'create' or 'handles'

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 01-May-98.
%   Last Revision: 13-Jan-2001.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:04:01 $

if isempty(find(wfindobj('figure')==fig)) , return; end

% Tagged Objects.
%----------------
tag_col_par = 'Fra_ColPar';

switch option
    case 'create'
        % Get globals.
        %-------------
        [...
        Def_Txt_Height,Def_Btn_Height,Def_Btn_Width, ...
        X_Spacing,Y_Spacing,sliYProp,Lst_ColorMap,   ...
        Def_EdiBkColor,Def_FraBkColor] = ...
            mextglob('get',...
                'Def_Txt_Height','Def_Btn_Height','Def_Btn_Width',   ...
                'X_Spacing','Y_Spacing','Sli_YProp', ...
                'Lst_ColorMap','Def_EdiBkColor','Def_FraBkColor'  ...
                );

        % Positions utilities.
        %---------------------
        dx = X_Spacing; bdx = 3;
        dy = Y_Spacing; bdy = 4;        
        d_txt  = (Def_Btn_Height-Def_Txt_Height);
        deltaY = (Def_Btn_Height+0*dy);
        sli_hi = Def_Btn_Height*sliYProp;
        sli_dy = 0.5*Def_Btn_Height*(1-sliYProp);

        % Default Values.
        %----------------
        maxmax_nbcolors = 448;
        min_nbcolors = 2;
        def_nbcolors = 128;
        min_bright   = -2;
        max_bright   = 2;
        def_bright   = 0;

        % Defaults Inputs.
        %----------------
        xleft = Inf; xright  = Inf; xloc = Inf;
        ytop  = Inf; ybottom = Inf; yloc = Inf;
        pos_close = wfigmngr('get',fig,'pos_close');
        if ~isempty(pos_close)
            ybottom = pos_close(2)+pos_close(4)+2*dy;
        end
        bkColor = Def_FraBkColor;
        briFlag = 1;
        enaVAL  = 'off';
        max_nbcolors = 256;

        % Parsing Inputs.
        %----------------        
        nbarg = nargin-2;
        for k=1:2:nbarg
            arg = lower(varargin{k});
            switch arg
              case 'left'    , xleft   = varargin{k+1};
              case 'right'   , xright  = varargin{k+1};
              case 'xloc'    , xloc    = varargin{k+1};
              case 'bottom'  , ybottom = varargin{k+1};
              case 'top'     , ytop    = varargin{k+1};
              case 'yloc'    , yloc    = varargin{k+1};
              case 'bkcolor' , bkColor = varargin{k+1};              
              case 'briflag' , briFlag = varargin{k+1};
              case 'enable'  , enaVAL  = varargin{k+1};
              case 'maxnbcol', max_nbcolors = varargin{k+1};
            end
        end
        str_numfig = num2mstr(fig);
        old_units  = get(fig,'units');
        fig_units  = 'pixels';
        if ~isequal(old_units,fig_units), set(fig,'units',fig_units); end       

        % Setting frame position.
        %------------------------
        w_fra   = wfigmngr('get',fig,'fra_width');
        h_fra   = Def_Btn_Height+(1+briFlag)*deltaY+2*bdy;
        xleft   = utposfra(xleft,xright,xloc,w_fra);
        ybottom = utposfra(ybottom,ytop,yloc,h_fra);
        pos_fra = [xleft,ybottom,w_fra,h_fra];

        % String property of objects.
        %----------------------------
        str_txt_pal = 'Colormap';
        str_txt_nbc = 'Nb. Colors';
        str_pop_pal = Lst_ColorMap;
        str_edi_nbc = sprintf('%.0f',size(get(fig,'Colormap'),1));
        if briFlag , str_txt_bri = 'Brightness'; end

        % Position property of objects.
        %------------------------------
        xleft          = xleft+bdx;
        ylow           = ybottom+h_fra-Def_Btn_Height-bdy;               
        pos_txt_pal    = [xleft,ylow+d_txt/2,Def_Btn_Width,Def_Txt_Height];
        pos_pop_pal    = [xleft,ylow,Def_Btn_Width,Def_Btn_Height];
        pos_pop_pal(1) = pos_pop_pal(1)+pos_txt_pal(3);
        ylow           = ylow-deltaY;
        
        pos_txt_nbc    = pos_txt_pal;
        pos_txt_nbc(2) = pos_txt_nbc(2)-deltaY;
        xl             = pos_txt_nbc(1)+pos_txt_nbc(3);
        pos_sli_nbc    = [xl, ylow+sli_dy, Def_Btn_Width, sli_hi];
        xl             = pos_sli_nbc(1)+pos_sli_nbc(3)+dx;
        pos_edi_nbc    = [xl, ylow, Def_Btn_Width/2, Def_Btn_Height];
        if briFlag
            ylow           = ylow-deltaY;
            pos_txt_bri    = pos_txt_nbc;
            pos_txt_bri(2) = pos_txt_bri(2)-deltaY;
            xl             = pos_txt_bri(1)+pos_txt_bri(3);
			pos_p_M_bri    = [xl, ylow, Def_Btn_Width/2, Def_Btn_Height];
			xl             = xl+Def_Btn_Width/2;
			pos_p_P_bri    = [xl, ylow, Def_Btn_Width/2, Def_Btn_Height];
        end

        % Create objects.
        %----------------
        fra_utl = uicontrol('Parent',fig, ...
                            'Style','frame', ...
                            'Unit',fig_units, ...
                            'Position',pos_fra, ...
                            'Backgroundcolor',bkColor, ...
                            'tag',tag_col_par, ...
                            'TooltipString','Colormap Settings' ...
                            );

        txt_pal = uicontrol('Parent',fig,...
                            'Style','Text',...
                            'Unit',fig_units,...
                            'Position',pos_txt_pal,...
                            'HorizontalAlignment','left',...
                            'Backgroundcolor',bkColor,...
                            'String',str_txt_pal...
                            );

        pop_pal = uicontrol('Parent',fig,...
                            'Style','Popup',...
                            'Unit',fig_units,...
                            'Position',pos_pop_pal,...
                            'String',str_pop_pal,...
                            'Enable',enaVAL...
                            );

        txt_nbc = uicontrol('Parent',fig,...
                            'Style','Text',...
                            'Unit',fig_units,...
                            'Position',pos_txt_nbc,...
                            'HorizontalAlignment','left',...
                            'Backgroundcolor',bkColor,...
                            'String',str_txt_nbc...
                            );
 
        sli_nbc = uicontrol('Parent',fig,...
                            'Style','Slider',...
                            'Unit',fig_units,...
                            'Position',pos_sli_nbc,...
                            'Min',min_nbcolors,...
                            'Max',max_nbcolors,...
                            'Value',def_nbcolors,...
                            'Enable',enaVAL...
                            );

        edi_nbc = uicontrol('Parent',fig,...
                            'Style','Edit',...
                            'Unit',fig_units,...
                            'Backgroundcolor',Def_EdiBkColor,...
                            'Position',pos_edi_nbc,...
                            'String',str_edi_nbc,...
                            'Enable',enaVAL ...
                            );
 
        % Callbacks update.
        %------------------
        cbaFileName = 'cbcolmap';
        cba_pop_pal = [cbaFileName '(''pal'',' str_numfig ');'];

        cba_edi_nbc = [cbaFileName '(''nbc'',' str_numfig ',' ...
                                num2mstr([edi_nbc]) ');'];

        cba_sli_nbc = [cbaFileName '(''nbc'',' str_numfig ',' ...
                                num2mstr([sli_nbc]) ');'];

        set(pop_pal,'Callback',cba_pop_pal);
        set(edi_nbc,'Callback',cba_edi_nbc);
        set(sli_nbc,'Callback',cba_sli_nbc);
 
        if briFlag
             txt_bri = uicontrol('Parent',fig,...
                                 'Style','Text',...
                                 'Unit',fig_units,...
                                 'Position',pos_txt_bri,...
                                 'HorizontalAlignment','left',...
                                 'Backgroundcolor',bkColor,...
                                 'String',str_txt_bri...
                                 );

			p_M_bri = uicontrol('Parent',fig,...
                                'Style','Pushbutton',...
								'String','-',...
                                'Unit',fig_units,...
								'FontSize',12,...
								'FontWeight','bold',...
                                'Position',pos_p_M_bri,...
                                'Enable',enaVAL ...
                                );
		
            p_P_bri = uicontrol('Parent',fig,...
                                'Style','Pushbutton',...
								'String','+',...
                                'Unit',fig_units,...
								'FontSize',12,...
								'FontWeight','bold',...
                                'Position',pos_p_P_bri,...
                                'Enable',enaVAL ...
                                );
          cba_p_M_bri = [cbaFileName '(''bri'',' str_numfig ',-1);'];
          set(p_M_bri,'Callback',cba_p_M_bri);
		  cba_p_P_bri = [cbaFileName '(''bri'',' str_numfig ',+1);'];
          set(p_P_bri,'Callback',cba_p_P_bri);
        else
            txt_bri = NaN;  p_M_bri = NaN; p_P_bri = NaN;
        end
        drawnow;        
        ud.handles = [fra_utl; ...
                      txt_pal;pop_pal;txt_nbc;sli_nbc;edi_nbc; ...
                      txt_bri;p_M_bri;p_P_bri];
        set(fra_utl,'Userdata',ud);
        if ~isequal(old_units,fig_units)
            set([fig;ud.handles],'units',old_units);
        end       
        if nargout>0
            varargout{1} = [pop_pal,sli_nbc,edi_nbc,p_M_bri,p_P_bri];
            varargout{2} = [fra_utl,txt_pal,txt_nbc,txt_bri];
        end

		% Add Context Sensitive Help (CSHelp).
		%-------------------------------------
		wfighelp('add_ContextMenu',fig,ud.handles,'UT_COLMAP');
		%-------------------------------------

    case 'handles'
        fra = findobj(fig,'Style','frame','tag',tag_col_par);
        ud  = get(fra,'Userdata');
        varargout{1} = ud.handles;
        nbarg = length(varargin);
        if nbarg>0
           type = varargin{1};
           switch type
             case 'all'  ,
             case 'act'  , varargout{1} = varargout{1}([3 5 6 8 9]);
             case 'cell' ,
               tmp = varargout{1}([3 5 6 8 9]);
               ind = ~isnan(tmp);
               varargout = {[];[];[];[];[]};
               varargout(ind) = num2cell(tmp(ind));
               return
           end
           if nbarg>1         
               varargout{1} = varargout{1}(ishandle(varargout{1}));
           end
        end 

    case 'position'
        fra = findobj(fig,'style','frame','tag',tag_col_par);
        varargout = get(fra,{'Position','Units'});

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end
