function varargout = utanapar(option,fig,varargin)
%UTANAPAR Utilities for wavelet analysis parameters.
%   VARARGOUT = UTANAPAR(OPTION,FIG,VARARGIN)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 04-May-98.
%   Last Revision: 20-Feb-2001.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:04:01 $

% Default values.
%----------------
max_lev_anal = 12;

% Tag property of objects.
%-------------------------
tag_ana_par = 'Fra_AnaPar';

switch option
    case 'create'
        % Get Globals.
        %--------------
        [Def_Txt_Height,Def_Btn_Height, ...
         X_Spacing,Y_Spacing,Def_FraBkColor] = ...
            mextglob('get',...
                'Def_Txt_Height','Def_Btn_Height', ...
                'X_Spacing','Y_Spacing','Def_FraBkColor');

        % Positions utilities.
        %---------------------
        dx = X_Spacing; bdx = 3;
        dy = Y_Spacing; bdy = 4;        
        d_txt  = (Def_Btn_Height-Def_Txt_Height);
        deltaY = (Def_Btn_Height+dy);

        % Defaults.
        %----------
        xleft = Inf; xright  = Inf; xloc = Inf;
        ytop  = Inf; ybottom = Inf; yloc = Inf;
        bkColor = Def_FraBkColor;
        datFlag = 1;
        levFlag = 1;
        enaVAL  = 'on';
        wtype   = 'dwt';
        deflev  = 1;
        maxlev  = max_lev_anal;

        % Inputs.
        %--------        
        nbarg = length(varargin);
        for k=1:2:nbarg
            arg = lower(varargin{k});
            switch arg
              case 'left'    , xleft   = varargin{k+1};
              case 'right'   , xright  = varargin{k+1};
              case 'xloc'    , xloc    = varargin{k+1};
              case 'bottom'  , ybottom = varargin{k+1};
              case 'top'     , ytop    = varargin{k+1};
              case 'yloc'    , yloc    = varargin{k+1};
              case 'bkcolor' , bkColor = varargin{k+1};              
              case 'datflag' , datFlag = varargin{k+1};
              case 'levflag' , levFlag = varargin{k+1};
              case 'enable'  , enaVAL  = varargin{k+1};
              case 'wtype'   , wtype   = varargin{k+1};
              case 'deflev'  , deflev  = varargin{k+1};
              case 'maxlev'  , maxlev  = varargin{k+1};
            end 
        end
        str_numfig = num2mstr(fig);
        old_units  = get(fig,'units');
        fig_units  = 'pixels';
        if ~isequal(old_units,fig_units), set(fig,'units',fig_units); end       

        % Setting frame position.
        %------------------------
        w_fra   = wfigmngr('get',fig,'fra_width');
        h_fra   = Def_Btn_Height+(datFlag+levFlag)*deltaY+2*bdy;
        xleft   = utposfra(xleft,xright,xloc,w_fra);
        ybottom = utposfra(ybottom,ytop,yloc,h_fra);
        pos_fra = [xleft,ybottom,w_fra,h_fra];

        % String property of objects.
        %----------------------------
        if datFlag
            str_txt_typ = 'Data  (Size)';
            str_txt_nam = '';
        end
        str_txt_wav = 'Wavelet';
        str_pop_fam = wavemngr('tfsn',wtype);
        str_pop_num = wavemngr('fields',{'fsn',str_pop_fam(1,:)},'tabNums');
        if isempty(str_pop_num) , str_pop_num = 'no'; end
        if levFlag
            str_txt_lev = 'Level';
            str_levels  = int2str([1:maxlev]');
        end

        % Position property of objects.
        %------------------------------
        w_uic = (w_fra-3*bdx)/3;
        x_uic = pos_fra(1)+bdx;
        ylow  = ybottom+h_fra-Def_Btn_Height-bdy;
        
        if datFlag
            pos_txt_typ = [x_uic, ylow+d_txt/2, w_uic, Def_Txt_Height];
            xleft       = pos_txt_typ(1)+pos_txt_typ(3);
            pos_txt_nam = [xleft , ylow , 2*w_uic , Def_Btn_Height];
            ylow        = ylow-deltaY;
        end
        xplus = 2;     
        pos_txt_wav    = [x_uic, ylow+d_txt/2, w_uic, Def_Txt_Height];
        xleft          = pos_txt_wav(1)+pos_txt_wav(3);
        pos_pop_fam    = [xleft, ylow, w_uic-xplus, Def_Btn_Height];
        pos_pop_num    = pos_pop_fam;
        pos_pop_num(1) = pos_pop_fam(1)+w_uic;
        pos_pop_num(3) = w_uic;

        if levFlag
            ylow           = ylow-deltaY;
            pos_txt_lev    = pos_txt_wav;
            pos_txt_lev(2) = ylow+d_txt/2;
            xleft          = pos_txt_lev(1)+pos_txt_lev(3);
            pos_pop_lev    = [xleft, ylow, w_uic-xplus, Def_Btn_Height];
        end

        % Create objects.
        %----------------
        comFigProp = {'Parent',fig,'Unit',fig_units};
        fra_utl = uicontrol(comFigProp{:},...
                            'Style','frame', ...
                            'Position',pos_fra, ...
                            'Backgroundcolor',bkColor, ...
                            'Tag',tag_ana_par ...
                            );

        if datFlag
            txt_typ = uicontrol(comFigProp{:},...
                                'Style','text',               ...
                                'HorizontalAlignment','left', ...
                                'Position',pos_txt_typ,       ...
                                'String',str_txt_typ,         ...
                                'Backgroundcolor',bkColor     ...
                                );

            txt_nam = uicontrol(comFigProp{:},...
                                'Style','Edit',           ...
                                'Position',pos_txt_nam,   ...
                                'String',str_txt_nam,     ...
                                'Enable','inactive',      ...
                                'Backgroundcolor',bkColor ...
                                );
        else
            txt_typ = NaN;
            txt_nam = NaN;
        end
        txt_wav = uicontrol(comFigProp{:},...
                            'Style','text',               ...
                            'HorizontalAlignment','left', ...
                            'Position',pos_txt_wav,       ...
                            'String',str_txt_wav          ...
                            );

        pop_fam = uicontrol(comFigProp{:},...
                            'Style','Popup',        ...
                            'Position',pos_pop_fam, ...
                            'String',str_pop_fam,   ...
                            'Enable',enaVAL         ...
                            );

        pop_num = uicontrol(comFigProp{:},...
                            'Style','Popup',        ...
                            'Position',pos_pop_num, ...
                            'String',str_pop_num,   ...
                            'Visible','Off',        ...
                            'Enable',enaVAL         ...
                            );
        cbanapar('cba_fam',fig,[pop_fam,pop_num]);
        if levFlag
            txt_lev = uicontrol(comFigProp{:},...
                                'Style','text',               ...
                                'HorizontalAlignment','left', ...
                                'Position',pos_txt_lev,       ...
                                'String',str_txt_lev,         ...
                                'Backgroundcolor',bkColor     ...
                                );

            pop_lev = uicontrol(comFigProp{:},...
                                'Style','Popup',        ...
                                'Position',pos_pop_lev, ...
                                'String',str_levels,    ...
                                'Enable',enaVAL,        ...
                                'Value',deflev          ...
                                );
        else
            txt_lev = NaN;
            pop_lev = NaN;
        end

        % Callbacks update.
        %------------------
        pop_str     = num2mstr([pop_fam;pop_num]);
        cba_pop_fam = ['cbanapar(''cba_fam'',' str_numfig ',' pop_str ');']; 
        cba_pop_num = ['cbanapar(''cba_num'',' str_numfig ',' pop_str ');'];
        set(pop_fam,'Callback',cba_pop_fam);
        set(pop_num,'Callback',cba_pop_num);

		% Add Context Sensitive Help (CSHelp).
		%-------------------------------------
		hdl_UT_WAVELET = [txt_wav,pop_fam,pop_num];
		wfighelp('add_ContextMenu',fig,hdl_UT_WAVELET,'UT_WAVELET');
		%-------------------------------------

        % Store handles.
        %---------------
        ud.handles = [fra_utl;txt_typ;txt_nam;...
                      txt_wav;pop_fam;pop_num;txt_lev;pop_lev];
        set(fra_utl,'Userdata',ud);
        if ~isequal(old_units,fig_units)
            set([fig;ud.handles],'units',old_units);
        end       
        drawnow;
 
        if nargout>0 , varargout = {pos_fra , ud.handles}; end

    case 'create_copy'
        createArg = varargin{1};
        cbArg     = varargin{2};
        [toolPos,hdlNew] = utanapar('create',fig,createArg{:});
        popNew = findobj(hdlNew,'style','popupmenu');
        cbanapar('set',fig,cbArg{:});
        copyOpt = 1;
        if copyOpt
            Def_FraBkColor = mextglob('get','Def_FraBkColor');
            prop    = get(popNew,{'Value','String'});
            newProp = {'Style','Edit','BackGroundColor',Def_FraBkColor, ...
                       'Enable','Inactive', ...
                       'String'};
            for k = 1:size(prop,1)
               set(popNew(k),newProp{:},prop{k,2}(prop{k,1},:));
            end
        else
            inactCol = mextglob('get','Def_TxtBkColor');
            set(popNew,'enable','inactive','ForeGroundColor',inactCol);
        end
        if nargout>0 , varargout = {toolPos,hdlNew}; end

    case 'create_copyB'
        inFig = varargin{1};
        uic = findobj(get(fig,'Children'),'flat','type','uicontrol');
        fra = findobj(uic,'style','frame','tag',tag_ana_par);
        ud  = get(fra,'userdata');
        handles = ud.handles;
        handles = copyobj(handles,inFig);
	
        % Store handles.
        %---------------
        ud.handles = handles;
        set(handles(1),'Userdata',ud);
		
        pop = findobj(handles,'style','popupmenu');
        if ~isempty(pop)
            Def_FraBkColor = mextglob('get','Def_FraBkColor');
            prop    = get(pop,{'Value','String'});
            newProp = {'Style','Edit','BackGroundColor',Def_FraBkColor, ...
                       'Enable','Inactive', ...
                       'String'};
            for k = 1:size(prop,1)
               set(pop(k),newProp{:},prop{k,2}(prop{k,1},:));
            end
        end

		% Add Context Sensitive Help (CSHelp).
		%-------------------------------------
		[txt_wav,pop_fam,pop_num] = utanapar('handles',inFig,'nam','fam','num');
		hdl_UT_WAVELET = [txt_wav,pop_fam,pop_num];
		wfighelp('add_ContextMenu',inFig,hdl_UT_WAVELET,'UT_WAVELET');
		%-------------------------------------

    case 'handles'
        uic = findobj(get(fig,'Children'),'flat','type','uicontrol');
        fra = findobj(uic,'style','frame','tag',tag_ana_par);
        ud  = get(fra,'userdata');
        handles = ud.handles;
        handles([1,4,7]) = [];
        nbarg = length(varargin);
        if nbarg>0 & isequal(varargin{1},'all')
            varargout{1} = handles; return
        end       
        varargout = num2cell(handles);
        if  nbarg<1 , return; end
        ind = [];
        for k = 1:nbarg
           hdlType = varargin{k};
           switch hdlType
             case 'typ' , ind = [ind;1];
             case 'nam' , ind = [ind;2];
             case 'fam' , ind = [ind;3];
             case 'num' , ind = [ind;4];
             case 'lev' , ind = [ind;5];
             case 'pop' , ind = [ind;[3:5]'];
           end       
        end
        varargout = varargout(ind);

    case {'toolPosition','position'}
        fra = findobj(fig,'style','frame','tag',tag_ana_par);
        varargout = get(fra,{'Position','Units'});

    case 'set_cba_num'
        [pop_fam,pop_num] = utanapar('handles',fig,'fam','num');
        if nargin>2
            ena_hdl = varargin{1};
            pop_str = num2mstr([pop_fam ; pop_num]);
            cba_pop_num = ['cbanapar(''cba_num'','        ...
                            num2mstr(fig) ',' pop_str ',' ...
                            num2mstr([ena_hdl]) ');'];
            set(pop_num,'Callback',cba_pop_num);
        end 

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end
