function y = upcoef2(o,x,varargin)
%UPCOEF2 Direct reconstruction from 2-D wavelet coefficients.
%   Y = UPCOEF2(O,X,'wname',N,S) computes the N-step 
%   reconstructed coefficients of matrix X and takes the
%   size-S central portion of the result.
%   'wname' is a string containing the name of the wavelet.
%   If O = 'a', approximation coefficients are reconstructed,
%   otherwise if O = 'h' (or 'v' or 'd'), horizontal
%   (vertical or diagonal, respectively),
%   detail coefficients are reconstructed.
%   N must be a strictly positive integer.
%
%   Instead of giving the wavelet name, you can give the
%   filters.
%   For Y = UPCOEF2(O,X,Lo_R,Hi_R,N,S) 
%   Lo_R is the reconstruction low-pass filter and
%   Hi_R is the reconstruction high-pass filter.
% 
%   Y = UPCOEF2(O,X,'wname') is equivalent to
%   Y = UPCOEF2(O,X,'wname',1).
%
%   Y = UPCOEF2(O,X,Lo_R,Hi_R) is equivalent to
%   Y = UPCOEF2(O,X,Lo_R,Hi_R,1).
%
%   See also IDWT2.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 02-Aug-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.13 $

% Check arguments.
if errargn(mfilename,nargin,[3:6],nargout,[0 1]), error('*'), end
if isempty(x) , y = x; return; end

o = lower(o(1));
y = x; n = 1; s = [0 0];
if ischar(varargin{1})
    [Lo_R,Hi_R] = wfilters(varargin{1},'r'); next = 2;
else
    Lo_R = varargin{1}; Hi_R = varargin{2};  next = 3;
end
if nargin>=(2+next)
    n = varargin{next}; 
    if nargin>=(3+next), s = varargin{next+1}; end
end

if (n<0) | (n~=fix(n)) | ~isempty(find(s<0)) | ~isempty(find(s~=fix(s)))
    errargt(mfilename,'invalid argument value','msg'); error('*');
end
if n==0 , return; end

switch o
    case 'a' , F1 = Lo_R; F2 = Lo_R;
    case 'h' , F1 = Hi_R; F2 = Lo_R;
    case 'v' , F1 = Lo_R; F2 = Hi_R;
    case 'd' , F1 = Hi_R; F2 = Hi_R;
    otherwise
        errargt(mfilename,'invalid argument value','msg'); error('*');
end

dwtATTR = 'dummy';
lf = length(Lo_R);
sy = 2*size(y)+lf-2;
y  = upsaconv('2D',y,{F1,F2},sy,dwtATTR);
for p=2:n
    sy = 2*size(y)+lf-2;
    y  = upsaconv('2D',y,{Lo_R,Lo_R},sy,dwtATTR);
end
if prod(s), y = wkeep(y,s); end;
