function shaninfo
%SHANINFO Information on complex Shannon wavelet.
%
%   Complex Shannon Wavelet
%
%   Definition: a complex Shannon wavelet is
%           shan(x) = Fb^{0.5}*sinc(Fb*x)*exp(2*i*pi*Fc*x)
%   depending on two parameters:
%           Fb is a bandwidth parameter
%           Fc is a wavelet center frequency
%
%   Family                  Complex Shannon
%   Short name              shan
%
%   Wavelet name            shan"Fb"-"Fc"
%
%   Orthogonal              no
%   Biorthogonal            no
%   Compact support         no
%   DWT                     no
%   complex CWT             possible
%
%   Support width           infinite
%
%   Reference: A. Teolis, 
%   Computational signal processing with wavelets, 
%   Birkhauser, 1998, 62.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 18-Jun-99.
%   Last Revision: 08-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:03:47 $

