function y = qmf(x,p)
%QMF    Quadrature mirror filter.
%   Y = QMF(X,P) changes the signs of the even index entries
%   of the reversed vector filter coefficients X if P is even.
%   If P is odd the same holds for odd index entries.
%
%   Y = QMF(X) is equivalent to Y = QMF(X,0).

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 01-May-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.9 $

% Check arguments.
if errargn(mfilename,nargin,[1:2],nargout,[0:1]), error('*'), end
if nargin == 1 , p = 0; end
if errargt(mfilename,p,'in0'), error('*'), end

% Compute quadrature mirror filter.
y = wrev(x);
first = 2-rem(p,2);
y(first:2:end) = -y(first:2:end);
