function nottn = noleaves(varargin)
%NOLEAVES Determine nonterminal nodes.
%   N = NOLEAVES(T) returns the indices of nonterminal 
%   nodes of the tree T (i.e., nodes, which are not leaves).
%   N is a column vector.
%
%   N = NOLEAVES(T,'dp') returns a matrix N, which
%   contains the depths and positions of nonterminal nodes.
%   N(i,1) is the depth of i-th nonterminal node and
%   N(i,2) is the position of i-th nonterminal node.
%
%   See also LEAVES.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Oct-96.
%   Last Revision: 26-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.7 $  $Date: 2001/03/30 16:03:39 $

% Check arguments.
if errargn(mfilename,nargin,[1:2],nargout,[0:1]), error('*'); end

nottn = wtreemgr('noleaves',varargin{:});
