function [out1,out2] = morlet(varargin)
%MORLET Morlet wavelet.
%   [PSI,X] = MORLET(LB,UB,N) returns values of 
%   the Morlet wavelet on an N point regular grid 
%   in the interval [LB,UB].
%   Output arguments are the wavelet function PSI
%   computed on the grid X, and the grid X.
%
%   This wavelet has [-4 4] as effective support.
%
%   See also WAVEINFO.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $

% Check arguments.
if errargn(mfilename,nargin,[3 4],nargout,[0:2]), error('*'); end

% Compute values of the Morlet wavelet.
out2 = linspace(varargin{1:3});        % wavelet support.
out1 = exp(-(out2.^2)/2) .* cos(5*out2);
