function [out1,out2] = mngmbtn(option,fig,varargin)
%MNGMBTN Manage mouse buttons for the dynamical visualization tool.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 01-May-96.
%   Last Revision: 14-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.12 $

EraseMode = 'xor';
msel_box  = 'n';
msel_trans = 'e';
msel_txt   = 'a';
msel_open  = 'o';

switch option
    case 'move'
        %**********************************************%
        %** OPTION = 'move' DEPLACEMENT DE LA SOURIS **%
        %**********************************************%
        %   DynV_Axe_Sel    = in3(1);
        %   DynV_Btn_Xpos   = in3(2); (optional)
        %   DynV_Btn_Ypos   = in3(3); (optional)
        %   mouseT = in4 (selection type)
        %-----------------------------------------
        if get(0,'PointerWindow')~=fig , return; end
        DynV_Axe_Sel = varargin{1}(1);
        mouseT = varargin{2};
        
        [q,x,y] = waxecp(fig,DynV_Axe_Sel);
        if prod(x-q(1))>0 | prod(y-q(2))>0
            % set(fig,'WindowButtonMotionFcn','wtmotion','WindowButtonUpFcn','');
            set(fig,'Pointer','arrow');
            if mouseT~=msel_box , mngmbtn('delLines',fig,'V_H'); end

        %--- selection d'un rectangle ---%
        elseif mouseT==msel_box
            dVTmemB = dynvtool('rmb',fig);
            DynV_Sel_Box = dVTmemB.DynV_Sel_Box;       
            if ~isempty(DynV_Sel_Box)
                pzbx = get(DynV_Sel_Box,'XData');
                pzby = get(DynV_Sel_Box,'YData');
                set(DynV_Sel_Box,...
                        'XData', [pzbx(1) q(1) q(1) pzbx(1) pzbx(1)],...
                        'YData', [pzby(1) pzby(1) q(2) q(2) pzby(1)]);
            end

        %--- ecriture de la position ---%
        elseif mouseT==msel_txt
            dVTmemB = dynvtool('rmb',fig);
            DynV_Line_Hor = dVTmemB.DynV_Line_Hor;
            DynV_Line_Ver = dVTmemB.DynV_Line_Ver;
            if isempty(DynV_Line_Hor) , return; end
            set(DynV_Line_Hor,'YData',[q(2) q(2)]);
            set(DynV_Line_Ver,'XData',[q(1) q(1)]);
            if length(varargin{1})<3 , return; end
            DynV_Btn_Xpos = varargin{1}(2);
            DynV_Btn_Ypos = varargin{1}(3);
            mempos_coor = get(DynV_Btn_Xpos,'UserData');
            fcn_wri   = wmemutil('get',mempos_coor,1);
            param_wri = wmemutil('get',mempos_coor,2);
            if isempty(param_wri)
               [sx,sy] = feval(fcn_wri,q(1),q(2),DynV_Axe_Sel);
            else
               [sx,sy] = feval(fcn_wri,q(1),q(2),DynV_Axe_Sel,param_wri);
            end
            set(DynV_Btn_Xpos,'String',sx);
            set(DynV_Btn_Ypos,'String',sy);
        
        %--- gestion des translations ---%
        elseif mouseT==msel_trans
            dVTmemB = dynvtool('rmb',fig);
            DynV_Line_Hor = dVTmemB.DynV_Line_Hor;
            DynV_Line_Ver = dVTmemB.DynV_Line_Ver;
            if isempty(DynV_Line_Hor) , return; end
            x1 = get(DynV_Line_Hor,'XData');
            y1 = get(DynV_Line_Hor,'YData');
            u  = get(DynV_Axe_Sel,'Units');
            rect = get(DynV_Axe_Sel,'Position');
            rx = abs((x1(2)-q(1))/(x(2)-x(1)));
            ry = abs((y1(2)-q(2))/(y(2)-y(1)));
            k  = rect(3)*rx-rect(4)*ry;
            if k>0
                set(DynV_Line_Hor,...
                        'XData',[x1(2) x1(2) x1(2)],...
                        'YData',[y(1)  y1(2) y(2) ] ...
                        );
                set(DynV_Line_Ver,...
                        'XData',[q(1) q(1) q(1)],   ...
                        'YData',[y(1) q(2) y(2)]    ...
                        );
                DynV_Flg_Trans = 1;
            elseif k<0
                set(DynV_Line_Hor,...
                        'XData',[x(1)  x1(2) x(2) ],...
                        'YData',[y1(2) y1(2) y1(2)] ...
                        );
                set(DynV_Line_Ver,...
                        'XData',[x(1) q(1) x(2)],   ...
                        'YData',[q(2) q(2) q(2)]    ...
                        );
                DynV_Flg_Trans = 2;
            else
                DynV_Flg_Trans = 0;
            end
            dVTmemB.flgTrans = DynV_Flg_Trans;
            dynvtool('wmb',fig,dVTmemB);
        end

    case 'down'
        %***************************************************%
        %** OPTION = 'down' UN BOUTON DE LA SOURIS APPUYE **%
        %***************************************************%
        if isempty(find(wfindobj('figure')==fig)) , return; end
        if get(0,'PointerWindow')~=fig
            dVTmemB = mngmbtn('delLines',fig,'All');
        else
            dVTmemB = dynvtool('rmb',fig);
        end
        mouse  = get(fig,'SelectionType');
        mouseT = mouse(1);
        
        axe_hdls = dVTmemB.axeInd;
        if mouseT==msel_txt
            % DynV_Axe_Act + DynV_Axe_Ind
            axe_hdls = [dVTmemB.axeAct , axe_hdls];

        else    
            % DynV_Axe_Cmd + DynV_Axe_Ind
            axe_hdls = [dVTmemB.axeCmd , axe_hdls];
        end
        axe_hdls = findobj(axe_hdls,'flat','Visible','on');
        DynV_Axe_Sel = [];
        for i=1:length(axe_hdls)
            ax      = axe_hdls(i);
            [q,x,y] = waxecp(fig,ax);
            if  prod(x-q(1))<0 & prod(y-q(2))<0
                DynV_Axe_Sel = ax;
                break;
            end
        end
        dVTmemB.axeSel = DynV_Axe_Sel;
		dynvtool('wmb',fig,dVTmemB);
        dVTmemB = mngmbtn('delLines',fig,'Down',dVTmemB,DynV_Axe_Sel,mouseT);
		if isempty(DynV_Axe_Sel) , return; end
			
	    if ~isappdata(fig,'save_WindowButtonUpFcn')
		    save_WindowButtonUpFcn = get(fig,'WindowButtonUpFcn');
		    setappdata(fig,'save_WindowButtonUpFcn',save_WindowButtonUpFcn);
	    end
		
        DynV_Btn_Xpos = dVTmemB.handles.DynV_Btn_Xpos;
        DynV_Btn_Ypos = dVTmemB.handles.DynV_Btn_Ypos;
        DynV_Col_Line = dVTmemB.linColor;

        %--- selection d'un rectangle ---%
        switch mouseT
            case msel_box
                set(fig,'Pointer','crosshair', ...
                        'CurrentAxes',DynV_Axe_Sel);
                if ~isempty(DynV_Btn_Xpos)
                    set(DynV_Btn_Xpos,'String','X = ');
                    set(DynV_Btn_Ypos,'String','Y = ');
                end
                DynV_Sel_Box = line(...
                        'Color',DynV_Col_Line,...
                        'EraseMode',EraseMode,...
                        'XData',[q(1) q(1) q(1) q(1) q(1)],...
                        'YData',[q(2) q(2) q(2) q(2) q(2)] ...
                        );
                dVTmemB.DynV_Sel_Box = DynV_Sel_Box;

        %--- ecriture de la position ---%
            case msel_txt
                set(fig,'Pointer','crosshair', ...
                        'CurrentAxes',DynV_Axe_Sel);
                DynV_Line_Hor = line(...
                        'Color',DynV_Col_Line,...
                        'EraseMode',EraseMode,...
                        'XData',[x(1) x(2)],...
                        'YData',[q(2) q(2)] ...
                        );
                DynV_Line_Ver = line(...
                        'Color',DynV_Col_Line,...
                        'EraseMode',EraseMode,...
                        'XData',[q(1) q(1)],...
                        'YData',[y(1) y(2)] ...
                        );
                dVTmemB.DynV_Line_Hor = DynV_Line_Hor;
                dVTmemB.DynV_Line_Ver = DynV_Line_Ver;

                if ~isempty(DynV_Btn_Xpos)
                    mempos_coor = get(DynV_Btn_Xpos,'UserData');
                    fcn_wri   = wmemutil('get',mempos_coor,1);
                    param_wri = wmemutil('get',mempos_coor,2);
                    if isempty(param_wri)
                       [sx,sy] = feval(fcn_wri,q(1),q(2),DynV_Axe_Sel);
                    else
                       [sx,sy] =  ...
                            feval(fcn_wri,q(1),q(2),DynV_Axe_Sel,param_wri);
                    end
					dynvtool('set_BtnOnOff',fig,'On','Info');
                    set(DynV_Btn_Xpos,'String',sx);
                    set(DynV_Btn_Ypos,'String',sy);
                end

        %--- gestion des translations ---%
            case msel_trans
                set(fig,'Pointer','crosshair','CurrentAxes',DynV_Axe_Sel);
                if ~isempty(DynV_Btn_Xpos)
                    set(DynV_Btn_Xpos,'String','X = ');
                    set(DynV_Btn_Ypos,'String','Y = ');
                end
                DynV_Line_Hor = line(...
                        'LineStyle','--',...
                        'Color',DynV_Col_Line,...
                        'EraseMode',EraseMode,...
                        'XData',[x(1) q(1) x(2)],...
                        'YData',[q(2) q(2) q(2)] ...
                        );
                DynV_Line_Ver = line(...
                        'LineStyle','--',...
                        'Color',DynV_Col_Line,...
                        'EraseMode',EraseMode',...
                        'XData',[q(1) q(1) q(1)],...
                        'YData',[y(1) q(2) y(2)] ...
                        );
                dVTmemB.DynV_Line_Hor = DynV_Line_Hor;
                dVTmemB.DynV_Line_Ver = DynV_Line_Ver;
                dVTmemB.flgTrans = 0;

        %--- open ---%
            case msel_open
              set(fig,'Pointer','arrow');
              mempos_coor = get(DynV_Btn_Xpos,'UserData');
              fcn_sel = wmemutil('get',mempos_coor,3);
              if ~isempty(fcn_sel)
				  param_sel = wmemutil('get',mempos_coor,4);
				  if isempty(param_sel)
					  [sx,sy] = feval(fcn_sel,q(1),q(2),DynV_Axe_Sel);
				  else
					  [sx,sy] = feval(fcn_sel,q(1),q(2),DynV_Axe_Sel,param_sel);
				  end
				  if ~isempty(sx)
					  DynV_Line_Hor = line(...
						  'Color',DynV_Col_Line,...
						  'EraseMode',EraseMode,...
						  'XData',[x(1) x(2)],...
						  'YData',[q(2) q(2)] ...
						  );
					  DynV_Line_Ver = line(...
						  'Color',DynV_Col_Line,...
						  'EraseMode',EraseMode,...
						  'XData',[q(1) q(1)],...
						  'YData',[y(1) y(2)] ...
						  );
					  if ~isempty(DynV_Btn_Xpos)
						  set(DynV_Btn_Xpos,'String',sx);
						  set(DynV_Btn_Ypos,'String',sy);
					  end
					  dVTmemB.DynV_Line_Hor = DynV_Line_Hor;
					  dVTmemB.DynV_Line_Ver = DynV_Line_Ver;
				  end
			  end
        end
		handles  = num2mstr([DynV_Axe_Sel,DynV_Btn_Xpos,DynV_Btn_Ypos]);
		endstr   = [sprintf('%0.f',fig) ',' handles ',''' mouseT ''');'];
		cba_move = [mfilename '(''move'',' endstr];
		cba_up   = [mfilename '(''up'',' endstr];
		set(fig,'WindowButtonMotionFcn',cba_move,'WindowButtonUpFcn',cba_up);
		dynvtool('wmb',fig,dVTmemB);

    case 'up'
        %*************************************************%
        %** OPTION = 'up' UN BOUTON DE LA SOURIS APPUYE **%
        %*************************************************%
        %   mouseT = in4 (selection type)
        %-----------------------------------------
        DynV_Axe_Sel = varargin{1}(1);
		
		if isappdata(fig,'save_WindowButtonUpFcn')
		    save_WindowButtonUpFcn = getappdata(fig,'save_WindowButtonUpFcn');
			rmappdata(fig,'save_WindowButtonUpFcn');
			eval(save_WindowButtonUpFcn);			
		else
			save_WindowButtonUpFcn = ''
		end
        set(fig,'WindowButtonMotionFcn','wtmotion',...
			    'WindowButtonUpFcn',save_WindowButtonUpFcn);

		set(fig,'Pointer','arrow');
        mouseT  = varargin{2};
		if mouseT==msel_open ,  return; end
		
        dVTmemB = dynvtool('rmb',fig);

        %--- gestion des translations ---%
        if mouseT==msel_trans
            DynV_Line_Hor = dVTmemB.DynV_Line_Hor;
            DynV_Line_Ver = dVTmemB.DynV_Line_Ver;
            DynV_Flg_Trans = dVTmemB.flgTrans;
            if DynV_Flg_Trans==1
                x1 = get(DynV_Line_Hor,'XData');
                x2 = get(DynV_Line_Ver,'XData');
                dx = x2(2)-x1(2);
            elseif DynV_Flg_Trans==2
                y1 = get(DynV_Line_Hor,'YData');
                y2 = get(DynV_Line_Ver,'YData');
                dy = y2(2)-y1(2);
            end
            dVTmemB = mngmbtn('delLines',fig,'V_H',dVTmemB);
            DynV_Axe_Ind = dVTmemB.axeInd;
            if ~isempty(DynV_Axe_Ind) & ...
               ~isempty(find(DynV_Axe_Sel==DynV_Axe_Ind))
                DynV_Axe_Act  = DynV_Axe_Sel;
                DynV_XY_Const = [0 0];
            else
                DynV_Axe_Act  = dVTmemB.axeAct;
                DynV_XY_Const = dVTmemB.xyConst;
            end
            if DynV_Flg_Trans==1
                x0 = get(DynV_Axe_Sel,'XLim');
                if DynV_XY_Const(1)~=0
                    set(DynV_Axe_Act,'XLim',x0-dx);
                else
                    set(DynV_Axe_Sel,'XLim',x0-dx);
                end
                dynvtool('put',fig);

            elseif DynV_Flg_Trans==2
                y0 = get(DynV_Axe_Sel,'YLim');
                if DynV_XY_Const(2)~=0
                    set(DynV_Axe_Act,'YLim',y0-dy);
                else
                    set(DynV_Axe_Sel,'YLim',y0-dy);
                end
                dynvtool('put',fig);
            end

        elseif mouseT==msel_box
            DynV_Sel_Box = dVTmemB.DynV_Sel_Box;
            xd = get(DynV_Sel_Box,'Xdata');
            yd = get(DynV_Sel_Box,'Ydata');
            xl = get(DynV_Axe_Sel,'xlim');
            yl = get(DynV_Axe_Sel,'ylim');
            tol = 0.01;
            if abs((max(xd)-min(xd))/(xl(2)-xl(1)))<tol  | ....
               abs((max(yd)-min(yd))/(yl(2)-yl(1)))<tol
                mngmbtn('delLines',fig,'Box',dVTmemB);
			else
				dynvtool('set_BtnOnOff',fig,'On','Zoom');
            end

        end

    case 'getbox'
        %****************************************************%
        %** OPTION = 'getbox' LECTURE DU RECTANGLE DE ZOOM **%
        %****************************************************%
        dVTmemB = dynvtool('rmb',fig);
        DynV_Sel_Box = dVTmemB.DynV_Sel_Box;
        if ~isempty(DynV_Sel_Box)
            out1 = get(DynV_Sel_Box,'XData');
            out2 = get(DynV_Sel_Box,'YData');
            if (min(out1)==max(out1)) | (min(out2)==max(out2))
                mngmbtn('delLines',fig,'Box',dVTmemB);
                out1 = [];
                out2 = [];
            end
        else
            out1 = [];
            out2 = [];
        end

    case 'delLines'
        if nargin<4 , 
            dVTmemB = dynvtool('rmb',fig);
        else
            dVTmemB = varargin{2};
        end
        linHDL = [];
        switch varargin{1}
          case 'Box' ,
            linHDL = dVTmemB.DynV_Sel_Box;
            dVTmemB.DynV_Sel_Box  = [];
			
          case {'V_H','H_V'}
            linHDL = [dVTmemB.DynV_Line_Hor,dVTmemB.DynV_Line_Ver];
            dVTmemB.DynV_Line_Hor = [];
            dVTmemB.DynV_Line_Ver = [];
			
          case {'All','Down'}
            linHDL = [dVTmemB.DynV_Sel_Box,...
                      dVTmemB.DynV_Line_Hor,dVTmemB.DynV_Line_Ver];
            dVTmemB.DynV_Sel_Box  = [];
            dVTmemB.DynV_Line_Hor = [];
            dVTmemB.DynV_Line_Ver = [];
        end
        delete(linHDL(ishandle(linHDL)));
        dynvtool('wmb',fig,dVTmemB);
	
		if ~isequal(varargin{1},'V_H') & ~isequal(varargin{1},'H_V')
			switch varargin{1}
			case 'All'  , typCall = 'All';
			case 'Box'  , typCall = 'Zoom';
			case 'Down'
				DynV_Axe_Sel = varargin{3};
				mouseT =  varargin{4};
				if ~isempty(DynV_Axe_Sel) & isequal(mouseT,msel_txt)
					typCall = 'All';
					% typCall = 'Zoom';
				else
					typCall = 'All';
				end
			end
			dynvtool('set_BtnOnOff',fig,'Off',typCall);
		end
        out1 = dVTmemB;

    case 'getLines'
        if nargin<4 , 
            dVTmemB = dynvtool('rmb',fig);
        else
            dVTmemB = varargin{2};
        end
        switch lower(varargin{1})
          case 'box' , out1  = dVTmemB.DynV_Sel_Box;
          case 'hor' , out1  = dVTmemB.DynV_Line_Hor;
          case 'ver' , out1  = dVTmemB.DynV_Line_Ver;
          case 'all' ,
            out1  = [dVTmemB.DynV_Sel_Box,dVTmemB.DynV_Line_Hor,dVTmemB.DynV_Line_Ver];
        end

    case 'cleanXYPos'
        handles = dynvtool('handles',fig);
        DynV_Btn_Xpos = handles.DynV_Btn_Xpos;
        DynV_Btn_Ypos = handles.DynV_Btn_Ypos;
        set(DynV_Btn_Xpos,'String','X = ');
        set(DynV_Btn_Ypos,'String','Y = ');

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end
