function y = meyeraux(x);
%MEYERAUX Meyer wavelet auxiliary function.
%   Y = MEYERAUX(X) returns values of the auxiliary
%   function used for Meyer wavelet generation evaluated
%   at the elements of the vector or matrix X.
%
%   The function is 35*x^4 - 84*x^5 + 70*x^6 - 20*x^7.
%
%   See also MEYER.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 01-May-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.9 $

% Check arguments.
if errargn(mfilename,nargin,[1],nargout,[0:1]), error('*'), end

% Auxiliary function values.
p = [-20 70 -84 35 0 0 0 0];
y = polyval(p,x);
