function [out1,out2] = mexihat(varargin)
%MEXIHAT Mexican hat wavelet.
%   [PSI,X] = MEXIHAT(LB,UB,N) returns values of 
%   the Mexican hat wavelet on an N point regular
%   grid in the interval [LB,UB].
%   Output arguments are the wavelet function PSI
%   computed on the grid X.
%
%   This wavelet has [-5 5] as effective support.
%
%   See also WAVEINFO.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $

% Check arguments.
if errargn(mfilename,nargin,[3 4],nargout,[0:2]), error('*'); end

% Compute values of the Mexican hat wavelet.
out2 = linspace(varargin{1:3}); % wavelet support.
out1 = out2.^2;
out1 = (2/(sqrt(3)*pi^0.25)) * exp(-out1/2) .* (1-out1);


