function [x,I] = localmax(x,rInit);
%LOCALMAX Compute local maxima.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 05-Oct-96.
%   Last Revision: 20-Dec-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.4 $  $Date: 2001/03/30 16:03:27 $

[r,c] = size(x);
if nargin==1 , rInit = r; end

% Regularization of  x (!?)
%--------------------------
regule = 1;
if regule==1
    wav = 'sym4';
    lev = 5;
    [cfs,len] = wavedec(x(rInit,:),lev,wav);
    x(rInit,:) = wrcoef('a',cfs,len,wav);
end
x    = [zeros(r,1) diff(abs(x),1,2)];
I    = find(abs(x)<sqrt(eps));
x(I) = zeros(size(I));
I    = find(x<0);
x(I) = -ones(size(I));
I    = find(x>0);
x(I) = ones(size(I));
x    = [zeros(r,1) diff(x,1,2)];
I    = find(x==-2);
x    = zeros(size(x));
x(I) = ones(size(I));

% Chain maxima - Eliminate "false" maxima.
%-----------------------------------------
ideb = rInit ; step = -1; ifin = 1;
max_down = find(x(ideb,:));
x(ideb,max_down) = max_down;
if rInit<2 , return; end

for i = ideb+step:step:ifin
    max_curr = find(x(i,:));
    val_max  = zeros(size(max_curr));
    for k = 1:length(max_down)
        [nul,ind] = min(abs(max_curr-max_down(k)));
        val_max(ind) = max_down(k);
    end
    x(i,max_curr) = val_max;
    max_down = max_curr(find(val_max));
end
