function [tn,K] = leaves(varargin)
%LEAVES Determine terminal nodes.
%   N = LEAVES(T) returns the indices of terminal 
%   nodes of the tree T where N is a column vector.
%
%   The nodes are ordered from left to right as in tree T.   
%
%   [N,K] = LEAVES(T,'s') or [N,K] = LEAVES(T,'sort')
%   returns sorted indices.
%   M = N(K) are the indices reordered as in tree T,
%   from left to right.
%
%   N = LEAVES(T,'dp') returns a matrix N, which contains
%   the depths and positions of terminal nodes.
%   N(i,1) is the depth of i-th terminal node.
%   N(i,2) is the position of i-th terminal node.
%
%   [N,K] = LEAVES(T,'sdp') or [N,K] = LEAVES(T,'pds') or
%   [N,K] = LEAVES(T,'sortdp') or [N,K] = LEAVES(T,'pdsort') 
%   return sorted nodes.
%
%   See also TNODES, NOLEAVES.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Oct-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.7 $  $Date: 2001/03/30 16:03:27 $

% Check arguments.
if errargn(mfilename,nargin,[1:2],nargout,[0:2]), error('*'); end

[tn,K] = wtreemgr('leaves',varargin{:});
