function haarinfo
%HAARINFO Information on Haar wavelet.
%
%   Haar Wavelet
%
%   General characteristics: Compactly supported 
%   wavelet, the oldest and the simplest wavelet.
%   
%   scaling function phi = 1 on [0 1] and 0 otherwise.
%   wavelet function psi = 1 on [0 0.5[, = -1 on [0.5 1] and 0 otherwise.
%
%   Family                  Haar
%   Short name              haar
%   Examples                haar is the same as db1
%   Orthogonal              yes
%   Biorthogonal            yes
%   Compact support         yes
%   DWT                     possible
%   CWT                     possible
%
%   Support width           1
%   Filters length          2
%   Regularity              haar is not continuous
%   Symmetry                yes
%   Number of vanishing 
%   moments for psi         1
%
%   Reference: I. Daubechies, 
%   Ten lectures on wavelets, 
%   CBMS, SIAM, 61, 1994, 194-202.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 01-May-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.9 $

