function fbspinfo
%FBSPINFO Information on complex Frequency B-Spline wavelet.
%
%   Complex Frequency B-Spline Wavelet
%
%   Definition: a complex Frequency B-Spline wavelet is
%       fbsp(x) = Fb^{0.5}*(sinc(Fb*x/M))^M *exp(2*i*pi*Fc*x)
%   depending on three parameters:
%           M is an integer order parameter (>=1)
%           Fb is a bandwidth parameter
%           Fc is a wavelet center frequency
%
%   Family                  Complex Frequency B-Spline
%   Short name              fbsp
%
%   Wavelet name            fbsp"M"-"Fb"-"Fc"
%
%   Orthogonal              no
%   Biorthogonal            no
%   Compact support         no
%   DWT                     no
%   complex CWT             possible
%
%   Support width           infinite
%
%   Reference: A. Teolis, 
%   Computational signal processing with wavelets, 
%   Birkhauser, 1998, 63.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 18-Jun-99.
%   Last Revision: 08-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:03:10 $

