function varargout = dw1dtool(option,varargin)
%DW1DTOOL Discrete Wavelet 1-D tool.
%   VARARGOUT = DW1DTOOL(OPTION,VARARGIN)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 20-Feb-2001.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.16 $ $Date: 2001/03/30 16:02:50 $

% Test inputs.
%-------------
if nargin==0 , option = 'create'; end
[option,winAttrb] = utguidiv('ini',option,varargin{:});

% Default values.
%----------------
max_lev_anal = 12;
default_nbcolors = 128;

% MemBloc0 of stored values.
%---------------------------
n_InfoInit   = 'DW1D_InfoInit';
ind_filename =  1;
ind_pathname =  2;
nb0_stored   =  2;

% MemBloc1 of stored values.
%---------------------------
n_param_anal   = 'DWAn1d_Par_Anal';
ind_sig_name   = 1;
ind_sig_size   = 2;
ind_wav_name   = 3;
ind_lev_anal   = 4;
ind_axe_ref    = 5;
ind_act_option = 6;
ind_ssig_type  = 7;
ind_thr_val    = 8;
nb1_stored     = 8;

% MemBloc2 of stored values.
%---------------------------
n_coefs_longs = 'Coefs_and_Longs';
ind_coefs     = 1;
ind_longs     = 2;
nb2_stored    = 2;

% MemBloc3 of stored values.
%---------------------------
n_synt_sig = 'Synt_Sig';
ind_ssig   =  1;
nb3_stored =  1;

% MemBloc4 of stored values.
%---------------------------
n_miscella     = 'DWAn1d_Miscella';
ind_graph_area =  1;
ind_view_mode  =  2;
ind_savepath   =  3;
nb4_stored     =  3;

% Tag property of objects.
%-------------------------
tag_m_savesyn   = 'Save_Syn';
tag_m_savecfs   = 'Save_Cfs';
tag_m_savedec   = 'Save_Dec';
tag_pus_anal    = 'Pus_Anal';
tag_pus_deno    = 'Pus_Deno';
tag_pus_comp    = 'Pus_Comp';
tag_pus_hist    = 'Pus_Hist';
tag_pus_stat    = 'Pus_Stat';
tag_pop_viewm   = 'View_Mode';
tag_pus_dispopt = 'Pus_Options';
tag_valapp_scr  = 'ValApp_Scr';
tag_txtapp_scr  = 'TxtApp_Scr';
tag_valdet_scr  = 'ValDet_Scr';
tag_txtdet_scr  = 'TxtDet_Scr';
tag_declev      = 'Pop_DecLev';
tag_txtdeclev   = 'Txt_DecLev';
tag_Def_DispM   = 'Default_DispM';

switch option
    case 'create'
        % Get Globals.
        %--------------
        [Def_Btn_Height,Def_Btn_Width,Pop_Min_Width,  ...
         Def_Txt_Height,X_Spacing,Y_Spacing,Def_FraBkColor ] = ...
            mextglob('get',...
                'Def_Btn_Height','Def_Btn_Width','Pop_Min_Width',  ...
                'Def_Txt_Height','X_Spacing','Y_Spacing','Def_FraBkColor' ...
                );

        % Wavelet 1-D window initialization.
        %-----------------------------------
        win_title = 'Wavelet 1-D';
        [win_dw1dtool,pos_win,win_units,str_numwin,...
            frame0,pos_frame0,Pos_Graphic_Area,pus_close] = ...
                wfigmngr('create',win_title,winAttrb,'ExtFig_Tool',mfilename,1,1,0);
        varargout{1} = win_dw1dtool;
		
		% Add Help for Tool.
		%------------------
		wfighelp('addHelpTool',win_dw1dtool,'&One-Dimensional Analysis','DW1D_GUI');

		% Add Help Item.
		%----------------
		wfighelp('addHelpItem',win_dw1dtool,'Wavelets in Action','DW1D_INACTION');
		wfighelp('addHelpItem',win_dw1dtool,'General Concepts','DW1D_GENERAL');
		wfighelp('addHelpItem',win_dw1dtool,'Wavelet Decomposition','DW1D_DECOMPOS');
		wfighelp('addHelpItem',win_dw1dtool,'Loading and Saving','DW1D_LOADSAVE');	
		
        % Menu construction for current figure.
        %--------------------------------------
		[m_files,m_load,m_save,m_view] = ...
			wfigmngr('getmenus',win_dw1dtool,'file','load','save','view');
        m_loadsig = uimenu(m_load,...
                                'Label','&Signal',   ...
                                'Position',1,             ...
                                'Callback',               ...
                                ['dw1dmngr(''load_sig'',' ...
                                        str_numwin ');']  ...
                                );

        m_loadcfs = uimenu(m_load,...
                                'Label','&Coefficients',  ...
                                'Position',2,             ...
                                'Callback',               ...
                                ['dw1dmngr(''load_cfs'',' ...
                                        str_numwin ');']  ...
                                );
        m_loaddec = uimenu(m_load,...
                                'Label','&Decomposition', ...
                                'Position',3,             ...
                                'Callback',               ...
                                ['dw1dmngr(''load_dec'',' ...
                                        str_numwin ');']  ...
                                );

		m_savesyn = uimenu(m_save,...
                                'Label','&Synthesized Signal',...
                                'Position',1,                 ...
                                'Enable','Off',               ...
                                'Tag',tag_m_savesyn,          ...
                                'Callback',                   ...
                                ['dw1dmngr(''save_synt'','    ...
                                        str_numwin ');']      ...
                                );
        m_savecfs = uimenu(m_save,...
                                'Label','&Coefficients',  ...
                                'Position',2,             ...
                                'Enable','Off',           ...
                                'Tag',tag_m_savecfs,      ...
                                'Callback',               ...
                                ['dw1dmngr(''save_cfs'',' ...
                                        str_numwin ');']  ...
                                );
        m_savedec = uimenu(m_save,...
                                'Label','&Decomposition', ...
                                'Position',3,             ...
                                'Enable','Off',           ...
                                'Tag',tag_m_savedec,      ...
                                'Callback',               ...
                                ['dw1dmngr(''save_dec'',' ...
                                        str_numwin ');']  ...
                                );
        m_demo = uimenu(m_files,...
                   'Label','&Example Analysis','Position',3,'Separator','Off');

        m_demo_1 = uimenu(m_demo,'Label','Basic Signals');
        m_demo_2 = uimenu(m_demo,...
			'Label','Noisy Signals - Constant Noise Variance');
        m_demo_3 = uimenu(m_demo,...
			'Label','Noisy Signals - Interval Dependent Noise Variance');
			   
			   
        % Submenu of test signals.
        %-------------------------
        names(1,:)  = 'Sum of sines               ';
        names(2,:)  = 'Frequency breakdown        ';
        names(3,:)  = 'Uniform white noise        ';
        names(4,:)  = 'AR(3) noise                ';
        names(5,:)  = 'Noisy polynomial           ';
        names(6,:)  = 'Noisy polynomial           ';
        names(7,:)  = 'Step signal                ';
        names(8,:)  = 'Two nearby discontinuities ';
        names(9,:)  = 'Two nearby discontinuities ';
        names(10,:) = 'Second derivative breakdown';
        names(11,:) = 'Second derivative breakdown';
        names(12,:) = 'Ramp + white noise         ';
        names(13,:) = 'Ramp + colored noise       ';
        names(14,:) = 'Sine + white noise         ';
        names(15,:) = 'Triangle + sine            ';
        names(16,:) = 'Triangle + sine + noise    ';
        names(17,:) = 'Electrical consumption     ';
        names(18,:) = 'Cantor curve               ';
        names(19,:) = 'Koch curve                 ';

        files = [ 'sumsin  ' ; 'freqbrk ' ; 'whitnois' ; 'warma   ' ; ...
                  'noispol ' ; 'noispol ' ; 'wstep   ' ; 'nearbrk ' ; ...
                  'nearbrk ' ; 'scddvbrk' ; 'scddvbrk' ; 'wnoislop' ; ...
                  'cnoislop' ; 'noissin ' ; 'trsin   ' ; 'wntrsin ' ; ...
                  'leleccum' ; 'wcantor ' ; 'vonkoch '                    ];    

        waves = ['db3' ; 'db5' ; 'db3' ; 'db3' ; 'db2' ; 'db3' ; 'db2' ; ...
                 'db2' ; 'db7' ; 'db1' ; 'db4' ; 'db3' ; 'db3' ; 'db5' ; ...
                 'db5' ; 'db5' ; 'db3' ; 'db1' ; 'db1'                      ];

        levels = ['5';'5';'5';'5';'4';'4';'5';'5';'5';'2';'2';'6';'6';'5';...
                        '6';'7';'5';'5';'5'];

        beg_call_str = ['dw1dmngr(''demo'',' str_numwin ','''];
        for i=1:size(files,1)
                libel = ['with ' waves(i,:) ' at level ' levels(i,:) ...
                                '  --->  ' names(i,:)];
                action = [beg_call_str files(i,:) ''',''' ...
                                waves(i,:) ''',' levels(i,:) ');'];
                uimenu(m_demo_1,'Label',libel,'Callback',action);
        end
	    names = [...
        	'Noisy blocks   '; ...
        	'Noisy bumps    '; ...
        	'Noisy heavysin '; ...
        	'Noisy Doppler  '; ...
        	'Noisy quadchirp'; ...
			'Noisy mishmash '  ...
			];
        files       = [ 'noisbloc' ; 'noisbump' ; 'heavysin' ; ...
                        'noisdopp' ; 'noischir' ; 'noismima'      ];
        waves   = ['sym8';'sym4';'sym8';'sym4';'db1 ';'db3 '];
        levels  = ['5';'5';'5';'5';'5';'5'];
        beg_call_str = ['dw1dmngr(''demo'',' str_numwin ','''];
        for i=1:size(files,1)
            libel = ['with ' waves(i,:) ' at level ' levels(i,:) ...
                            '  --->  ' names(i,:)];
            action = [beg_call_str files(i,:) ''',''' ...
                            waves(i,:) ''',' levels(i,:) ');'];
            uimenu(m_demo_2,'Label',libel,'Callback',action);
        end
        demoSET = {...
          'Noisy blocks (I)  - 3 intervals' , 'nblocr1' , 'sym4', 5 , 3  ; ...
          'Noisy blocks (II) - 3 intervals' , 'nblocr2' , 'sym4', 5 , 3  ; ...
          'Noisy Doppler (I) - 3 intervals' , 'ndoppr1' , 'sym4', 5 , 3  ; ...
          'Noisy bumps (I)   - 3 intervals' , 'nbumpr1' , 'sym4', 5 , 3  ; ...
          'Noisy bumps (II)  - 2 intervals' , 'nbumpr2' , 'sym4', 5 , 2  ; ...
          'Noisy bumps (III) - 4 intervals' , 'nbumpr3' , 'sym4', 5 , 4  ; ...
          'Elec. consumption - 3 intervals' , 'nelec'   , 'sym4', 5 , 3    ...
          };
        for k=1:length(demoSET)
            nam = demoSET{k,1};
            fil = demoSET{k,2};
            wav = demoSET{k,3};
            lev = int2str(demoSET{k,4});
            nbI = int2str(demoSET{k,5});        % Dummy
            libel = ['with ' wav ' at level ' lev  '  --->  ' nam];
            action = [beg_call_str fil ''',''' wav ''',' lev ');'];
            uimenu(m_demo_3,'Label',libel,'Callback',action);
        end

        % Adding option for choosing Default Display Mode.
        %-------------------------------------------------
        viewmode_Names  = strvcat(...
                            'Show and Scroll',    ...
                            'Full Decomposition', ...
                            'Separate Mode',      ...
                            'Superimpose Mode',   ...
                            'Tree Mode',          ...
                            'Show and Scroll (Stem Cfs)' ...
                            );
        viewmode_Names = viewmode_Names(1:end,:);
        DW1D_Display_Mode = 2;
        m_disp = uimenu(m_view,                         ...
                        'Label','Default Display &Mode', ...
                        'Separator','On'                ...
                        );
        nbm     = size(viewmode_Names,1);
        dm      = zeros(1,nbm);
        for k=1:nbm
            dm(k) = uimenu(m_disp,                      ...
                          'Label',viewmode_Names(k,:),  ...
                          'Checked','Off'               ...
                          );
        end
        dmstr = num2mstr(dm);
        for k = 1:nbm
            set(dm(k),            ...
                    'Userdata',k, ...
                    'CallBack',   ...
                    ['dw1dvdrv(''default'',' str_numwin ...
                    ','  dmstr ',' sprintf('%.0f',k) ');']);
        end
        dw1dvdrv('default',win_dw1dtool,dm,DW1D_Display_Mode);

        % Begin waiting.
        %---------------
        wwaiting('msg',win_dw1dtool,'Wait ... initialization');

        % Borders and double borders.
        %----------------------------
        dx = X_Spacing;   dx2 = 2*dx;
        dy = Y_Spacing;   dy2 = 2*dy;
        d_txt = (Def_Btn_Height-Def_Txt_Height);

        % Position property of objects.
        %------------------------------
        x_frame0    = pos_frame0(1);
        cmd_width   = pos_frame0(3);
        xlocINI     = pos_frame0([1 3]);
        ybottomINI  = pos_win(4)-3.5*Def_Btn_Height-dy2;

        y_low       = ybottomINI-2.5*Def_Btn_Height-dy2;
        w_uic       = 1.5*Def_Btn_Width;
        h_uic       = 1.5*Def_Btn_Height;
        bdx         = (cmd_width-w_uic)/2;
        x_left      = x_frame0+bdx;
        pos_anal    = [x_left, y_low, w_uic, h_uic];

        x_left      = x_frame0+dx2;
        y_low       = pos_anal(2)-h_uic-2*dy2;
        push_width  = (cmd_width-3*dx2)/2;
        pos_stat    = [x_left, y_low, push_width, h_uic];
        pos_comp    = pos_stat;
        pos_comp(1) = pos_stat(1)+pos_stat(3)+dx2;
        y_low       = y_low-h_uic-dy;
        pos_hist    = [x_left, y_low, push_width, h_uic];
        pos_deno    = pos_hist;
        pos_deno(1) = pos_hist(1)+pos_hist(3)+dx2;

        y_low           = pos_hist(2)-h_uic-2*dy2;
        pos_viewm_txt   = [x_left, y_low, 2*Def_Btn_Width, Def_Txt_Height];

        pop_width       = cmd_width-4*dx2;       
        x_left          = x_frame0+(cmd_width-pop_width)/2;
        y_low           = pos_viewm_txt(2)-Def_Btn_Height-dy;
        pos_pop_viewm   = [x_left, y_low, pop_width, Def_Btn_Height];

        pos_pus_dispopt = [x_left, y_low, pop_width, Def_Btn_Height];

        y_low           = pos_pop_viewm(2)-Def_Btn_Height-dy2;
        x_left          = pos_frame0(1)+dx2;
        w_txt           = Pop_Min_Width/2+dx/4;
        pos_txtapp_scr  = [x_left,y_low+d_txt/2, w_txt, Def_Txt_Height];
        xl              = pos_txtapp_scr(1)+pos_txtapp_scr(3)+dx;
        pos_valapp_scr  = [xl, y_low, Pop_Min_Width, Def_Btn_Height];
        xl              = pos_valapp_scr(1)+pos_valapp_scr(3)+dx2;
        pos_txtdet_scr  = [xl, y_low+d_txt/2, w_txt, Def_Txt_Height];
        xl              = pos_txtdet_scr(1)+pos_txtdet_scr(3)+dx;
        pos_valdet_scr  = [xl, y_low, Pop_Min_Width, Def_Btn_Height];

        y_low           = pos_pop_viewm(2)-Def_Btn_Height-dy2;
        pos_txtlev_dec  = [x_left, y_low+d_txt/2, Def_Btn_Width, Def_Txt_Height];
        xl              = pos_txtlev_dec(1)+Def_Btn_Width+dx2;
        pos_declev      = [xl, y_low, Pop_Min_Width, Def_Btn_Height];

        % String property of objects.
        %----------------------------
        str_levels      = int2str([1:max_lev_anal]');
        str_anal        = 'Analyze';
        str_stat        = 'Statistics';
        str_comp        = 'Compress';
        str_hist        = 'Histograms';
        str_deno        = 'De-noise';
        str_viewm_txt   = 'Display mode : ';
        str_pop_viewm   = viewmode_Names;
        str_pus_dispopt = 'More Display Options';
        str_txtapp_scr  = 'App.';
        str_valapp_scr  = str_levels;
        str_txtdet_scr  = 'Det.';
        str_valdet_scr  = str_levels;
        str_txtlev_dec  = 'at level';
        str_declev      = str_levels;


        % Callback property of objects.
        %------------------------------
        cba_anal    = ['dw1dmngr(''anal'',' str_numwin ');'];
        cba_stat    = ['dw1dmngr(''stat'',' str_numwin ');'];
        cba_comp    = ['dw1dmngr(''comp'',' str_numwin ');'];
        cba_hist    = ['dw1dmngr(''hist'',' str_numwin ');'];
        cba_deno    = ['dw1dmngr(''deno'',' str_numwin ');'];
        cba_viewm   = ['dw1dvmod(''ch_vm'',' str_numwin ');'];
        cba_mdisp   = ['dw1ddisp(''create'',' str_numwin ');'];
        cba_app_scr = ['dw1dtool(''app'',' str_numwin ');'];
        cba_det_scr = ['dw1dtool(''det'',' str_numwin ');'];
        cba_declev  = ['dw1dtool(''dec'',' str_numwin ');'];

        % Command part of the window.
        %============================

        % Data, Wavelet and Level parameters.
        %------------------------------------
        utanapar('create',win_dw1dtool, ...
                 'xloc',xlocINI,'bottom',ybottomINI,...
                 'enable','off', ...
                 'wtype','dwt'   ...
                 );

        commonProp = {...
            'Parent',win_dw1dtool, ...
            'Style','Pushbutton',  ...
            'Unit',win_units,      ...
            'Enable','off'         ...
            };
        pus_anal = uicontrol(commonProp{:},...
                             'Position',pos_anal,  ...
                             'String',str_anal,    ...
                             'Tag',tag_pus_anal,   ...
                             'Callback',cba_anal,  ...
                             'Interruptible','On'  ...
                             );

        pus_stat = uicontrol(commonProp{:},...
                             'Position',pos_stat,  ...
                             'String',str_stat,    ...
                             'Tag',tag_pus_stat,   ...
                             'Callback',cba_stat   ...
                             );

        pus_comp = uicontrol(commonProp{:},...
                             'Position',pos_comp,  ...
                             'String',str_comp,    ...
                             'Tag',tag_pus_comp,   ...
                             'Callback',cba_comp   ...
                             );

        pus_hist = uicontrol(commonProp{:},...
                             'Position',pos_hist,  ...
                             'String',str_hist,    ...
                             'Tag',tag_pus_hist,   ...
                             'Callback',cba_hist   ...
                             );

        pus_deno = uicontrol(commonProp{:},...
                             'Position',pos_deno,  ...
                             'String',str_deno,    ...
                             'Tag',tag_pus_deno,   ...
                             'Callback',cba_deno   ...
                             );

        txt_viewm  = uicontrol(...
                               'Parent',win_dw1dtool,          ...
                               'Style','text',                 ...
                               'Unit',win_units,               ...
                               'HorizontalAlignment','left',   ...
                               'Position',pos_viewm_txt,       ...
                               'String',str_viewm_txt,         ...
                               'Backgroundcolor',Def_FraBkColor...
                               );
        view_mode = 1;
        pop_viewm = uicontrol(...
                              'Parent',win_dw1dtool,    ...
                              'Style','Popup',          ...
                              'Unit',win_units,         ...
                              'Position',pos_pop_viewm, ...
                              'String',str_pop_viewm,   ...
                              'Value',view_mode,        ...
                              'UserData',view_mode,     ...
                              'Enable','off',           ...
                              'Callback',cba_viewm,     ...
                              'Tag',tag_pop_viewm       ...
                              );

        pus_dispopt     = uicontrol(...
                                    'Parent',win_dw1dtool,      ...
                                    'Style','Pushbutton',       ...
                                    'Unit',win_units,           ...
                                    'Position',pos_pus_dispopt, ...
                                    'String',str_pus_dispopt,   ...
                                    'Visible','off',            ...
                                    'Enable','off',             ...
                                    'Tag',tag_pus_dispopt,      ...
                                    'Interruptible','On',       ...
                                    'Callback',cba_mdisp        ...
                                    );

        txt_txtapp_scr  = uicontrol(...
                                        'Parent',win_dw1dtool,          ...
                                        'Style','Text',                 ...
                                        'Unit',win_units,               ...
                                        'Position',pos_txtapp_scr,      ...
                                        'Visible','Off',                ...
                                        'String',str_txtapp_scr,        ...
                                        'Backgroundcolor',Def_FraBkColor,...
                                        'Tag',tag_txtapp_scr            ...
                                        );
        pop_valapp_scr  = uicontrol(...
                                        'Parent',win_dw1dtool,          ...
                                        'Style','Popup',                ...
                                        'Unit',win_units,               ...
                                        'Position',pos_valapp_scr,      ...
                                        'Visible','Off',                ...
                                        'String',str_valapp_scr,        ...
                                        'Enable','off',                 ...
                                        'Tag',tag_valapp_scr,           ...
                                        'Callback',cba_app_scr          ...
                                        );
        txt_txtdet_scr  = uicontrol(...
                                        'Parent',win_dw1dtool,          ...
                                        'Style','Text',                 ...
                                        'Unit',win_units,               ...
                                        'Position',pos_txtdet_scr,      ...
                                        'Visible','Off',                ...
                                        'String',str_txtdet_scr,        ...
                                        'Backgroundcolor',Def_FraBkColor,...
                                        'Tag',tag_txtdet_scr            ...
                                        );
        pop_valdet_scr  = uicontrol(...
                                        'Parent',win_dw1dtool,          ...
                                        'Style','Popup',                ...
                                        'Unit',win_units,               ...
                                        'Position',pos_valdet_scr,      ...
                                        'Visible','Off',                ...
                                        'String',str_valdet_scr,        ...
                                        'Enable','off',                 ...
                                        'Tag',tag_valdet_scr,           ...
                                        'Callback',cba_det_scr          ...
                                        );

        txt_txtlev_dec  = uicontrol(...
                                        'Parent',win_dw1dtool,          ...
                                        'Style','Text',                 ...
                                        'Unit',win_units,               ...
                                        'Position',pos_txtlev_dec,      ...
                                        'Visible','Off',                ...
                                        'String',str_txtlev_dec,        ...
                                        'Backgroundcolor',Def_FraBkColor,...
                                        'Tag',tag_txtdeclev             ...
                                        );
        pop_declev      = uicontrol(...
                                        'Parent',win_dw1dtool, ...
                                        'Style','Popup',       ...
                                        'Unit',win_units,      ...
                                        'Position',pos_declev, ...
                                        'Visible','Off',       ...
                                        'String',str_declev,   ...
                                        'Enable','off',        ...
                                        'Tag',tag_declev,      ...
                                        'Callback',cba_declev  ...
                                        );

        % Adding colormap GUI.
        %---------------------
        utcolmap('create',win_dw1dtool, ...
                 'xloc',xlocINI,        ...
                 'enable','off',        ...
                 'briflag',0,           ...
                 'bkcolor',Def_FraBkColor);

        % Initial Mode.
        %--------------
        pos_txt1   = get(txt_txtapp_scr,'Position');
        pos_opt    = get(pus_dispopt,'Position');
        pos_opt(2) = pos_txt1(2)-Def_Btn_Height-2*dy2;
        set(pus_dispopt,'Position',pos_opt);
        set([txt_txtapp_scr, txt_txtdet_scr,...
             pop_valapp_scr, pop_valdet_scr, pus_dispopt],'Visible','on');

        drawnow

		% Add Context Sensitive Help (CSHelp).
		%-------------------------------------
		hdl_DW1D_DISPMODE = [txt_viewm,pop_viewm];
		hdl_DW1D_MOREDISP = [pus_dispopt];
		wfighelp('add_ContextMenu',win_dw1dtool,hdl_DW1D_DISPMODE,'DW1D_DISPMODE');
		wfighelp('add_ContextMenu',win_dw1dtool,hdl_DW1D_MOREDISP,'DW1D_MOREDISP');
		%-------------------------------------

        %  Normalisation.
        %----------------
        Pos_Graphic_Area = wfigmngr('normalize',win_dw1dtool,Pos_Graphic_Area);

        % Callbacks update.
        %------------------
        utanapar('set_cba_num',win_dw1dtool,[m_files;pus_anal]);

        % Memory for stored values.
        %--------------------------
        wmemtool('ini',win_dw1dtool,n_InfoInit,nb0_stored);
        wmemtool('ini',win_dw1dtool,n_param_anal,nb1_stored);
        wmemtool('ini',win_dw1dtool,n_coefs_longs,nb2_stored);
        wmemtool('ini',win_dw1dtool,n_synt_sig,nb3_stored);
        wmemtool('ini',win_dw1dtool,n_miscella,nb4_stored);
        wmemtool('wmb',win_dw1dtool,n_miscella,...
                       ind_graph_area,Pos_Graphic_Area);

        % Setting Initial Colormap.
        %--------------------------
        cbcolmap('set',win_dw1dtool,'pal',{'pink',default_nbcolors});

        % Initialize View Mode Parametres.
        %---------------------------------
        dw1dvmod('ini_vm',win_dw1dtool);

        % End waiting.
        %---------------
        wwaiting('off',win_dw1dtool);

    case {'app','det'}
        fig = varargin{1};
        pop_viewm = findobj(get(fig,'Children'),'flat','tag',tag_pop_viewm);
        view_mode = get(pop_viewm,'Value');
        switch view_mode
            case 1 , dw1dscrm(option,fig);
            case 6 , dw1dcfsm(option,fig);
        end

    case 'dec'
        fig = varargin{1};
        dw1ddecm('dec',fig);

    case 'close'
        % in2 = win_dw1dtool
        %--------------------
        fig = varargin{1};
        called_win = wfindobj('figure','Userdata',fig);
        delete(called_win);
        set(fig,'Visible','Off')
        drawnow
        feval('dw1dfile','del',fig);

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end
