function n = depo2ind(order,node)
%DEPO2IND Node depth-position to node index.
%   For a tree of order ORD, N = DEPO2IND(ORD,[D P])
%   computes the indices N of the nodes whose
%   depths and positions are encoded within [D,P].
%   The nodes are numbered from left to right and
%   from top to bottom. The root index is 0.
%
%   D (depths) and P (positions) are column vectors.
%   such that:
%     0 <= D and 0 <= P <= ORD^D-1.
%   Output indices N is a column vector of integers such that:
%     0 <= N < ((ORD^(max(D)+1))-1)/(ORD-1).
%
%   Note: for a column vector X, DEPO2IND(ORD,X) = X.
%
%   See also IND2DEPO.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.10 $

% Check arguments.
if errargn(mfilename,nargin,[2],nargout,[0:1]), error('*'); end

% At depth d, the index of the first (left)
% node is ind = (order^d-1)/(order-1)
% All indices at depth d are:
%     ip = (order^d-1)/(order-1) + p
%     with 0 <= p <= (order^d-1)

[r,c] = size(node);
switch c
    case 1 , n = node;
    case 2
        n = zeros(r,1);
        K = find(node(:,1));
        switch order
          case 1 ,    n(K) = node(K,1);
          otherwise , n(K) = (order.^node(K,1)-1)/(order-1)+node(K,2);
        end

    otherwise
        errargt(mfilename,'invalid argument value','msg'); error('*');
end

