function F = dbwavf(wname)
%DBWAVF Daubechies wavelet filters.
%   F = DBWAVF(W) returns the scaling filter
%   associated with Daubechies wavelet specified
%   by the string W where W = 'dbN'.
%   Possible values for N are:
%      N = 1, 2, 3, ... , 45.
%
%   See also DBAUX, WAVEINFO, WFILTERS.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 16-Sep-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.10 $

% Check arguments.
if errargn(mfilename,nargin,[0,1],nargout,[0:1]), error('*'); end
if nargin==0
    F = 45; 
   % F contains the number max for Daubechies wavelet.
    return
end

if lower(wname(1:2))=='ha'
    num = 1;
else
    lw = length(wname); ab = abs(wname);
    ii = lw+1; 
    while (ii>1) & (47<ab(ii-1)) & (ab(ii-1)<58) , ii = ii-1; end
    num = wstr2num(wname(ii:lw));
end

switch num
  case 1
  F = [...
   0.50000000000000   0.50000000000000  ...
                ];

  case 2
  F = [...
   0.34150635094622   0.59150635094587   0.15849364905378  -0.09150635094587 ...
                ];

  case 3
  F = [...
   0.23523360389270   0.57055845791731   0.32518250026371  -0.09546720778426 ...
  -0.06041610415535   0.02490874986589                                       ...
                ];

  case 4
  F = [...
   0.16290171402562   0.50547285754565   0.44610006912319  -0.01978751311791 ...
  -0.13225358368437   0.02180815023739   0.02325180053556  -0.00749349466513 ...
                ];

  case 5
  F = [...
   0.11320949129173   0.42697177135271   0.51216347213016   0.09788348067375 ...
  -0.17132835769133  -0.02280056594205   0.05485132932108  -0.00441340005433 ...
  -0.00889593505093   0.00235871396920                                       ...
                ];

  case 6
  F = [...
   0.07887121600143   0.34975190703757   0.53113187994121   0.22291566146505 ...
  -0.15999329944587  -0.09175903203003   0.06894404648720   0.01946160485396 ...
  -0.02233187416548   0.00039162557603   0.00337803118151  -0.00076176690258 ...
                ];

  case 7
  F = [...
   0.05504971537285   0.28039564181304   0.51557424581833   0.33218624110566 ...
  -0.10175691123173  -0.15841750564054   0.05042323250485   0.05700172257986 ...
  -0.02689122629486  -0.01171997078235   0.00887489618962   0.00030375749776 ...
  -0.00127395235906   0.00025011342658                                       ...
                ];

  case 8
  F = [...
   0.03847781105406   0.22123362357624   0.47774307521438   0.41390826621166 ...
  -0.01119286766665  -0.20082931639111   0.00033409704628   0.09103817842345 ...
  -0.01228195052300  -0.03117510332533   0.00988607964808   0.00618442240954 ...
  -0.00344385962813  -0.00027700227421   0.00047761485533  -0.00008306863060 ...
                ];

  case 9
  F = [...
   0.02692517479416   0.17241715192471   0.42767453217028   0.46477285717278 ...
   0.09418477475112  -0.20737588089628  -0.06847677451090   0.10503417113714 ...
   0.02172633772990  -0.04782363205882   0.00017744640673   0.01581208292614 ...
  -0.00333981011324  -0.00302748028715   0.00130648364018   0.00016290733601 ...
  -0.00017816487955   0.00002782275679
                ];

  case 10
  F = [...
   0.01885857879640   0.13306109139687   0.37278753574266   0.48681405536610 ...
   0.19881887088440  -0.17666810089647  -0.13855493935993   0.09006372426666 ...
   0.06580149355070  -0.05048328559801  -0.02082962404385   0.02348490704841 ...
   0.00255021848393  -0.00758950116768   0.00098666268244   0.00140884329496 ...
  -0.00048497391996  -0.00008235450295   0.00006617718320  -0.00000937920789 ...
                ];

  otherwise
    if (11<=num) & (num<=45)
       F = dbaux(num);
    else
      errargt(mfilename,'Invalid Daubechies wavelet number !','msg');
      error('*');
   end
end
