function [sx,sy] = cw1dcoor(x,y,axe,in4)
%CW1DCOOR Continuous wavelet 1-D coordinates.
%   [SX,SY] = CW1DCOOR(X,Y,AXE,IN4)

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 31-Aug-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.12 $

% MB2.
%-----
n_coefs_sca = 'Coefs_Scales';
ind_coefs   = 1;
ind_scales  = 2;
ind_frequences = 3;
ind_sca_OR_frq = 4;
nb2_stored  = 4;

sx = sprintf('X = %7.2f',x);
sy = sprintf('Y = %7.2f',y);
i_axe = find(axe==in4);
if ~isempty(i_axe)
  fig = get(axe,'Parent');
  idx = wmemtool('rmb',fig,n_coefs_sca,ind_sca_OR_frq);
  infos = wmemtool('rmb',fig,n_coefs_sca,idx);
  len = length(infos);
  if (len>0) & (1<=y) & (y<=len)
      y = round(y);
	  t = num2str(infos(y));
      switch idx
        case ind_scales     , sy = ['Sca = ' t];
        case ind_frequences , sy = ['Frq = ' t];
      end
	  sy = sy(1:min(11,length(sy)));
  end
end
