function [t,d] = convv1v2(t,d)
%CONVV1V2 Convert Wavelet Toolbox Data Structures.
%
%   T = CONVV1V2(T,D) converts V1 Data Structures
%   to V2 Data Structures. The output T is a wptree object.
%
%   [T,D] = CONVV1V2(T) converts V2 Data Structures
%   to V1 Data Structures. The input T is a wptree object.
%

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 15-Jul-99.
%   Last Revision: 20-Dec-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.4 $  $Date: 2001/03/30 16:02:23 $

% Check arguments.
%-----------------
if errargn(mfilename,nargin,[1:2],nargout,[1:2]), error('*'); end
nbarg = nargin+nargout;
if nbarg~=3
   errargt(mfilename,'Invalid number of inputs or outputs!','msg');
   error('*');
end

% Read tree parameters.
%----------------------
order = treeord(t);
depth = treedpth(t);
an_old = allnodes(t);
tn_old = leaves(t);

switch nargin
  case 1
    % Read new data structures.
    %--------------------------
    x = wpcoef(t,0);
    [wavName,entName,entPar] = get(t,'wavName','entName','entPar');
    ento = read(t,'ento',an_old);

    % Create old data structures.
    %----------------------------
    switch order
      case 2 , funcName = 'wpdec';
      case 4 , funcName = 'wpdec2';
    end
    [t,d] = feval(funcName,x,depth,wavName,entName,entPar);
    tn_new = leaves(t);
    n2m = setdiff(tn_old,tn_new);
    for j = 1:length(n2m)
        [t,d] = wpjoin(t,d,n2m(j));
    end
    d = wdatamgr('write_ento',d,ento,an_old);

  case 2
    % Read old data structures.
    %--------------------------
    x = wpcoef(t,d,0);
    wavName = wdatamgr('read_wave',d);
    [entName,entPar] = wdatamgr('read_tp_ent',d);
    ento = wdatamgr('read_ento',d,an_old);

    % Create new data structures.
    %----------------------------
    t = wptree(order,depth,x,wavName,entName,entPar);
    tn_new = leaves(t);
    n2m = setdiff(tn_old,tn_new);
    for j = 1:length(n2m)
        t = wpjoin(t,n2m(j));
    end
    write(t,'ento',ento,an_old);
end

