function F = coifwavf(wname)
%COIFWAVF Coiflet wavelet filter.
%   F = COIFWAVF(W) returns the scaling filter
%   associated with the coiflet wavelet specified
%   by the string W where W = 'coifN'.
%   Possible values for N are:
%      N = 1, 2, 3, 4 or 5.
%
%   See also WAVEINFO.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 26-Oct-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.10 $  $Date: 2001/03/30 16:02:23 $ 

% Check arguments.
if errargn(mfilename,nargin,[1],nargout,[0:1]), error('*'); end

lw = length(wname); ab = abs(wname);
ii = lw+1; 
while (ii>1) & (47<ab(ii-1)) & (ab(ii-1)<58) , ii = ii-1; end
num = wstr2num(wname(ii:lw));

switch num
  case 1
  F = [...
  -0.05142972847100   0.23892972847100   0.60285945694200   0.27214054305800 ...
  -0.05142972847100  -0.01107027152900                                       ...
                ];

  case 2
  F = [...
   0.01158759673900  -0.02932013798000  -0.04763959031000   0.27302104653500 ...
   0.57468239385700   0.29486719369600  -0.05408560709200  -0.04202648046100 ...
   0.01674441016300   0.00396788361300  -0.00128920335600  -0.00050950539900 ...
                ];

  case 3
  F = [...
  -0.00268241867100   0.00550312670900   0.01658356047900  -0.04650776447900 ...
  -0.04322076356000   0.28650333527400   0.56128525687000   0.30298357177300 ...
  -0.05077014075500  -0.05819625076200   0.02443409432100   0.01122924096200 ...
  -0.00636960101100  -0.00182045891600   0.00079020510100   0.00032966517400 ...
  -0.00005019277500  -0.00002446573400
                ];

  case 4
  F = [...
   0.00063096104600  -0.00115222485200  -0.00519452402600   0.01136245924400 ...
   0.01886723537800  -0.05746423442900  -0.03965264851700   0.29366739089500 ...
   0.55312645256200   0.30715732619800  -0.04711273886500  -0.06803812705100 ...
   0.02781364015300   0.01773583743800  -0.01075631851700  -0.00400101288600 ...
   0.00265266594600   0.00089559452900  -0.00041650057100  -0.00018382976900 ...
   0.00004408035400   0.00002208285700  -0.00000230494200  -0.00000126217500 ...
                ];

  case 5
  F = [...
  -0.00014996380000   0.00025356120000   0.00154024570000  -0.00294111080000 ...
  -0.00716378190000   0.01655206640000   0.01991780430000  -0.06499726280000 ...
  -0.03680007360000   0.29809232350000   0.54750542940000   0.30970684900000 ...
  -0.04386605080000  -0.07465223890000   0.02919587950000   0.02311077700000 ...
  -0.01397368790000  -0.00648009000000   0.00478300140000   0.00172065470000 ...
  -0.00117582220000  -0.00045122700000   0.00021372980000   0.00009937760000 ...
  -0.00002923210000  -0.00001507200000   0.00000264080000   0.00000145930000 ...
  -0.00000011840000  -0.00000006730000
                ];
  otherwise
    errargt(mfilename,'Invalid coiflet','msg');
    error('*');
end
