function [psi,X] = cmorwavf(varargin)
%CMORWAVF Complex Morlet wavelet.
%   [PSI,X] = CMORWAVF(LB,UB,N,FB,FC) returns values of
%   the complex Morlet wavelet defined by a positive bandwidth
%   parameter FB, a wavelet center frequency FC, and the expression
%   PSI(X) = ((pi*FB)^(-0.5))*exp(2*i*pi*FC*X)*exp(-(X^2)/FB)
%   on an N point regular grid in the interval [LB,UB].
%
%   Output arguments are the wavelet function PSI
%   computed on the grid X.
%
%   See also WAVEINFO.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 09-Jun-99.
%   Last Revision: 02-Aug-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:02:22 $

% Check arguments.
if errargn(mfilename,nargin,[4 5],nargout,[0:2]), error('*'); end

X = linspace(varargin{1:3});  % wavelet support.
Fc = 1;
Fb = 1;
switch nargin
  case 4
    if ischar(varargin{4})
       label = deblank(varargin{4});
       ind   = strncmpi('cmor',label,4);
       if isequal(ind,1)
          label([1:4]) = [];
          len = length(label);
          if len>0
             ind = findstr('-',label);
             if isempty(ind)
                Fb = []; % error 
             else
                Fc = wstr2num(label(1:ind-1));
                label(1:ind) = [];
                Fb = wstr2num(label);    
             end
          end
       else
          Fc = []; % error 
       end
    else
      Fb = []; % error 
    end
  case 5 , Fc = varargin{4}; Fb = varargin{5};
end
if isempty(Fc) | isempty(Fb) , err = 1; else , err = 0; end
if ~err , err = ~isnumeric(Fc) | ~isnumeric(Fb) | (Fc<=0) | (Fb<=0); end
if err
    msg = 'Invalid Wavelet Number!';
    error(msg)
end
psi = ((pi*Fb)^(-0.5))*exp(2*i*pi*Fc*X).*exp(-(X.*X)/Fb);
