function allN = allnodes(varargin)
%ALLNODES Tree nodes.
%   ALLNODES returns one of two node descriptions:
%   either indices, or depths and positions.
%   The nodes are numbered from left to right and
%   from top to bottom. The root index is 0.
%
%   N = ALLNODES(T) returns in column vector N
%   the indices of all nodes of the tree T.
%
%   N = ALLNODES(T,'deppos') returns in matrix N
%   the depths and positions of all the nodes.
%   N(i,1) is the depth and N(i,2) is the position
%   of node i.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 26-Jul-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.9 $

% Check arguments.
if errargn(mfilename,nargin,[1:2],nargout,[0:1]), error('*'); end

allN = wtreemgr('allnodes',varargin{:});
