function O = set(O,varargin)
%SET Set WTBO object field contents.
%   O = SET(O,'FieldName1',FieldValue1,'FieldName2',FieldValue2,...)
%   sets the contents of the specified fields for the WTBO object O.
%   
%   The valid choices for 'FieldName' are:
%     'wtboInfo' : Object information
%     'ud'       : Userdata field
%
%   Caution: Don't use the WTBO SET function!
%
%   See also GET.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Aug-2000.
%   Last Revision: 01-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:27:20 $

nbin = length(varargin);
for k=1:2:nbin
    field = varargin{k};
    kstr  = sprintf('%0.f',k+1);
    try   , eval(['O.' field ' = varargin{' kstr '};']);
    catch , lasterr('errorWTBX')
    end
end

