function x = wprec2(wpt)
%WPREC2 Wavelet packet reconstruction 2-D.
%   X = WPREC2(T) returns the reconstructed vector
%   corresponding to a wavelet packet tree T.
%
%   See also WPDEC, WPDEC2, WPJOIN, WPREC, WPSPLT.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 04-Jun-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:26:43 $

% Check arguments.
if errargn(mfilename,nargin,[1],nargout,[0 1]), error('*'); end

[wpt,x] = nodejoin(wpt);
