function x = wprcoef(t,node)
%WPRCOEF Reconstruct wavelet packet coefficients.
%   X = WPRCOEF(T,N) computes reconstructed coefficients
%   of the node N of the wavelet packet tree T.
%
%   X = WPRCOEF(T) is equivalent to X = WPRCOEF(T,0).
%
%   See also WPDEC, WPDEC2, WPREC, WPREC2.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 04-Jun-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:26:42 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[0:1]), error('*'); end
if nargin==1, node = 0; end
if find(isnode(t,node)==0)
    errargt(mfilename,'invalid node value','msg'); error('*');
end
x = rnodcoef(t,node);
