function [wpt,n2m] = wpcutree(wpt,level)
%WPCUTREE Cut wavelet packet tree.
%   T = WPCUTREE(T,L) cuts the tree T at level L.
%
%   In addition, [T,RN] = WPCUTREE(T,L) returns 
%   the vector RN which contains the indices
%   of the reconstructed nodes.
%
%   See also WPDEC, WPDEC2.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 14-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:26:40 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[1 2]), error('*'); end
if nargin==1 , level = 0; end
if level<0
    errargt(mfilename,'invalid level value','msg'); error('*');
end

[order,depth] = get(wpt,'order','depth');
if (level>=depth) | (depth==0) , n2m = []; return; end

nottn = noleaves(wpt,'dp');
K     = find(nottn(:,1)==level);
n2m   = depo2ind(order,nottn(K,:));
for k = 1:length(n2m)
    wpt = nodejoin(wpt,n2m(k));
end
