function x = wpcoef(wpt,node)
%WPCOEF Wavelet packet coefficients.
%   X = WPCOEF(T,N) returns the coefficients associated
%   with the node N of the wavelet packet tree T.
%   If N doesn't exist, X = [];
%
%   X = WPCOEF(T) is equivalent to X = WPCOEF(T,0) 
%
%   See also WPDEC, WPDEC2.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 04-Jun-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:26:39 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[0 1]), error('*'); end
if nargin==1, node = 0; end

[nul,x] = nodejoin(wpt,node);
