function [wpt,n2m] = wp2wtree(wpt)
%WP2WTREE Extract wavelet tree from wavelet packet tree.
%   T = WP2WTREE(T) computes the modified tree T
%   corresponding to the wavelet decomposition tree.
%
%   See also WPDEC, WPDEC2.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 14-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:26:39 $

% Check arguments.
if errargn(mfilename,nargin,[1],nargout,[1 2]), error('*'); end

[order,depth] = get(wpt,'order','depth');
if depth==0
    n2m = [];
    return
end

nottn = noleaves(wpt,'dp');
K     = find(0<nottn(:,2) & nottn(:,2)<order);
n2m   = depo2ind(order,nottn(K,:));

for k = 1:length(n2m)
    wpt = nodejoin(wpt,n2m(k));
end
