function [t,rec] = nodejoin(t,nodes)
%NODEJOIN Recompose node(s).
%   T = NODEJOIN(T,N) returns the modified tree T
%   corresponding to a recomposition of the nodes N.
%
%   The nodes are numbered from left to right and
%   from top to bottom. The root index is 0.
%
%   T = NODEJOIN(T) is equivalent to T = NODEJOIN(T,0).
%
%   See also NODESPLT.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 28-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:25:44 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[0:2]), error('*'); end
if nargin == 1, nodes = 0; end

[order,depth,tn] = get(t,'order','depth','tn');
nodes = depo2ind(order,nodes);
rec = [];

% Elimination of terminal nodes and irrelevant nodes.
%----------------------------------------------------
nodes = nodes(~ismember(nodes,tn));
nodes = nodes(logical(isnode(t,nodes)));
if isempty(nodes) , return; end

% Find new terminal nodes and new depth.
%---------------------------------------
tab = tabofasc(tn,order,depth);
for k = 1:length(nodes)
    node_k = nodes(k);
    [row,col] = find(tab==node_k);
    tab(row(1),1) = node_k;
    tab(row(2:end),1) = NaN;
    if nargout==2
        rec = [rec;recnodes(tab,row,col,node_k)];
    end
end
tn = tab(~isnan(tab(:,1)),1);
switch order
  case 1    , depth = max(tn);
  otherwise , depth = floor(log((order-1)*max(tn)+1)/log(order));
end
t = set(t,'depth',depth,'tn',tn);
if nargout==2 , rec = wrev(unique(rec)); end


function rec = recnodes(tab,row,col,node)
%RECNODES Find nodes to be reconstructed.
%
beg_col = 2;
icol    = find(col>beg_col);
end_col = max(col(icol))-1;
rec     = tab(row(icol),beg_col:end_col);
rec     = rec(:);
rec     = [node;rec(rec>node)];

