function disp(t)
%DISP Display information of NTREE object.
%
%   See also GET, SET.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Aug-2000.
%   Last Revision: 01-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.2 $  $Date: 2001/03/30 16:25:42 $

% Get wavelet packet tree information.
[order,depth,tn] = get(t,'order','depth','tn');

headerStr = [...
	' Tree Object Structure '
    '======================='
	];

infoStr = [...
	' order          : ' 
	' depth          : '
	' terminal nodes : '
	];


% Setting Strings.
%-----------------
tn = tn';
nb_tn = length(tn);
lStr = '['; 
if nb_tn>16 , nb_tn = 16; rStr = ' ...]'; else , rStr = ']'; end
tnStr = [lStr int2str(tn(1:nb_tn)) rStr];

addLen = 20;
sep = '-';
sepStr = sep(ones(1,size(infoStr,2)+addLen));	


% Displaying.
%------------
disp(' ')
disp(headerStr);
ind = 1; disp([infoStr(ind,:) , int2str(order)])
ind = ind+1; disp([infoStr(ind,:) , int2str(depth)])
ind = ind+1; disp([infoStr(ind,:) , tnStr])
disp(sepStr);
disp(' ')
