function t = write(t,varargin)
%WRITE Write values in DTREE object fields.
%   T = write(T,'data',DATA) writes data for all
%   terminal nodes.
%   T = write(T,'data',NODE,DATA) writes data for the
%   terminal node NODE.
%
%   Caution: Don't use the DTREE WRITE function!
%
%   See also DISP, GET, READ, SET.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 01-Jan-97.
%   Last Revision: 01-Dec-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.4 $  $Date: 2001/03/30 16:24:59 $

nbin = length(varargin);
k = 1;
while k<=nbin
  argNAME = lower(varargin{k});
  switch argNAME
    case 'data'
        % nextarg  = new data
        % or
        % nextarg = terminal node (index num or depth/pos num)
        % next nextarg = new data
        % out1 = new tree
        %--------------------------------------------------------
        if (k<nbin-1) & ~ischar(varargin{k+2})
            n_rank = istnode(t,varargin{k+1});
            if n_rank ~= 0
                order = get(t,'order');
                n_rank = depo2ind(order,n_rank);
                [beg,len,siz]  = fmdtree('tn_beglensiz',t,n_rank);
                sizcfs  = size(varargin{k+2});
                if ~isequal(siz,sizcfs)
                    errargt(mfilename,'invalid size for coefs','msg');
                    error('*');
                else
                    t = fmdtree('tn_write',t,n_rank,sizcfs,varargin{k+2});
                    k = k+1;
                end
            else
                errargt(mfilename,'invalid node value','msg');
                error('*');
            end
        else
            sizes = fmdtree('tn_read',t,'sizes');
            t = fmdtree('tn_write',t,sizes,varargin{k+1});
        end

    otherwise
        errargt(mfilename,'unknown object field','msg');
        error('*');
  end
  k = k+2;
end
