function x = rnodcoef(t,node)
%RNODCOEF Reconstruct node coefficients.
%   X = RNODCOEF(T,N) computes reconstructed coefficients
%   of the node N of the tree T.
%
%   X = RNODCOEF(T) is equivalent to X = RNODCOEF(T,0).

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 18-Oct-96.
%   Last Revision: 14-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:24:57 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[0:1]), error('*'); end
if nargin==1, node = 0; end
if find(isnode(t,node)==0)
    errargt(mfilename,'invalid node value','msg'); error('*');
end

% Get node data (coefficients).
[nul,x] = nodejoin(t,node);

order = get(t,'order');
asc   = nodeasc(t,node);
node  = asc(1);
if length(asc)<2 , return; end
sizes = read(t,'sizes',asc(2:end));
[d,p] = ind2depo(order,asc);
edges = rem(p,order);
edges = edges(1:end-1);

% Reconstruction.
x = recons(t,node,x,sizes,edges);
