function [t,x,rec] = nodejoin(t,node)
%NODEJOIN Recompose node.
%   T = NODEJOIN(T,N) returns the modified tree T
%   corresponding to a recomposition of the node N.
%
%   The nodes are numbered from left to right and
%   from top to bottom. The root index is 0.
%
%   T = NODEJOIN(T) is equivalent to T = NODEJOIN(T,0).
%
%   This method overloads the NTREE method and 
%   calls the right overloaded method MERGE.
%
%   See also MERGE, NODESPLT.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 15-Oct-96.
%   Last Revision: 14-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:24:52 $

% Check arguments.
if errargn(mfilename,nargin,[1 2],nargout,[0:3]), error('*'); end

if nargin == 1, node = 0; end
n_rank = istnode(t,node);
if n_rank>0
   rec = [];
   x   = fmdtree('tn_read',t,'data',n_rank);
   x   = x{1};
   return;
end

[order,t_copy] = get(t,'order','ntree');
node = depo2ind(order,node);
[tmp,rec] = nodejoin(t_copy,node);

elim = [];
for k=1:length(rec)
    node    = rec(k);
    i_child = node*order+[1:order]';
    elim    = [elim ; i_child];
    n_rank  = istnode(t_copy,i_child);
    t_copy  = nodejoin(t_copy,node);
    tndata  = fmdtree('tn_read',t,'data',n_rank);
    x       = merge(t,node,tndata);
    t       = fmdtree('tn_write',t,n_rank,size(x),x);
end
t = fmdtree('an_del',t,elim);
t = set(t,'ntree',t_copy);
