function dscedw1d(varargin)
%DSCEDW1D Demonstrates typical wavelet 1-D scenarios in the Wavelet Toolbox (Auto play). 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 16-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $


% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1; win_msg   = 1;
  case 2 , 
     figNumber = varargin{1};
     wait_mode = 1;
     win_msg   = 1;
  case 3 ,
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
        win_msg   = varargin{3};
    end
end
if exist('wait_mode')~=1 , wait_mode = 0; end
if exist('win_msg')~=1   , win_msg   = 1; end

% Tag property of objects.
%------------------------
tag_dem_tool = 'Demo_Tool';

% Default values.
%----------------
sig_nam = 'noisdopp';
wav_nam = 'sym4';
lev_dec = 5;

%----------------------------------------------------%
% Tag property of objects (main Window).
%---------------------------------------
tag_pop_viewm  = 'View_Mode';
tag_valapp_scr = 'ValApp_Scr';

% MemBloc1 of stored values.
%---------------------------
n_param_anal  = 'DWAn1d_Par_Anal';
ind_ssig_type = 7;

% Tag property of objects (More Display Option).
%----------------------------------------------
tag_win_disp = 'DispOpt1D';
tag_det_on   = 'Chk_Det';
tag_cfs_on   = 'Chk_Cfs';
tag_pop_ccfs = 'Pop_CCfs';

% Tag property of objects (Histograms).
%--------------------------------------
tag_det_sig   = 'Det_sig';
tag_det_all   = 'Det_All';
tag_sel_cfs   = 'Sel_Cfs';
tag_show_hist = 'Show_Hist';

% Memory of stored values (Compression).
%---------------------------------------
n_misc_comp = ['MB1_dw1dcomp'];
ind_status  = 2;
ind_pop_mod = 8;


% UTTHRGBL handlesUIC (Compression).
%-------------------------------------
% ud.handlesUIC = ...
%   [fra_utl;txt_top;pop_met;...
%    txt_sel;sli_sel;edi_sel;...
%    txt_nor;edi_nor;txt_npc;...
%    txt_zer;edi_zer;txt_zpc;...
%    tog_res;pus_est];
%-------------------------------------


% UTTHRW1D handlesUIC (De-noising).
%-------------------------------------
% ud.handlesUIC = ...
%   [fra_utl;txt_top;pop_met; ...
%    rad_sof;rad_har;txt_noi;pop_noi; ...
%    txt_BMS;sli_BMS;txt_tit(1:4),...
%    txt_nor;edi_nor;txt_npc; ...
%    txt_zer;edi_zer;txt_zpc; ...
%    tog_thr;tog_res;pus_est];
%----------------------------------------------------%

if wshowdrv('init',figNumber)
    if figNumber==0  
        win_dw1d = dw1dtool;
        wenamngr('Inactive',win_dw1d);
    else
        win_dw1d = demoscen('startshow',figNumber,'dw1dtool');
        wenamngr('Inactive',win_dw1d);
        wshowdrv('setactfig',figNumber,win_dw1d);
        return;
    end
end

if figNumber , win_dw1d = wshowdrv('getactfig',figNumber); end
stop = demoscen('msg',figNumber,wait_mode,1,win_msg,win_dw1d);
if stop , return; end

pop_win_dw1d = findobj(win_dw1d,'style','popupmenu');
pus_win_dw1d = findobj(win_dw1d,'style','pushbutton');
pop_viewm    = findobj(pop_win_dw1d,'tag',tag_pop_viewm);
pop_app_scr  = findobj(pop_win_dw1d,'tag',tag_valapp_scr);
%----------------------------------------------------%

% figure 1 - Full decomposition.
%-------------------------------
dw1dmngr('demo',win_dw1d,sig_nam,wav_nam,lev_dec);
wenamngr('Inactive',win_dw1d);
stop = demoscen('msg',figNumber,wait_mode,2,win_msg,win_dw1d);
if stop , return; end

% figure 2 - separate mode.
%--------------------------
set(pop_viewm,'value',3);
eval(get(pop_viewm,'Callback'));
stop = demoscen('msg',figNumber,wait_mode,6,win_msg,win_dw1d);
if stop , return; end

% figure 3 - Show and Scroll mode (app5+sig+cfs).
%------------------------------------------------
set(pop_viewm,'value',1);
eval(get(pop_viewm,'Callback'));
wshowdrv('pause',0,wait_mode,2);
dw1ddisp('create',win_dw1d);
win_mopt = wfindobj('figure','tag',tag_win_disp);
wenamngr('Inactive',win_mopt);
wshowdrv('pause',0,wait_mode,1);
uic_win_mopt = findobj(win_mopt,'Type','uicontrol');
chk_win_mopt = findobj(uic_win_mopt,'Style','checkbox');
pop_win_mopt = findobj(uic_win_mopt,'Style','popupmenu');
chk_det_on   = findobj(chk_win_mopt,'Tag',tag_det_on);
set(chk_det_on,'Value',0);
wshowdrv('pause',0,wait_mode,1);
dw1ddisp('apply',win_dw1d,win_mopt);
set(pop_app_scr,'Value',5);
eval(get(pop_app_scr,'Callback'));
if wshowdrv('pause',figNumber,wait_mode), return; end;

%------------------------------------------------

stop = demoscen('msg',figNumber,wait_mode,8,win_msg,win_dw1d);
if stop , return; end

% figure 4 - Show and Scroll mode (app5+sig+cfs ).
%            coloration : init + all levels + abs
%------------------------------------------------
figure(win_mopt);
drawnow
pause(1)
pop_ccfs = findobj(pop_win_mopt,'Tag',tag_pop_ccfs);
set(pop_ccfs,'Value',3);
pause(1)
dw1ddisp('apply',win_dw1d,win_mopt);
if wshowdrv('pause',figNumber,wait_mode), return; end;
dw1ddisp('close',win_dw1d,win_mopt);
wenamngr('Inactive',win_dw1d);

stop = demoscen('msg',figNumber,wait_mode,9,win_msg,win_dw1d);
if stop , return; end

% figure 5 - Histograms - all the detail coefficients.
%-----------------------------------------------------
win_hist        = dw1dmngr('hist',win_dw1d);
wenamngr('Inactive',win_hist);
uic_win_hist    = findobj(win_hist,'Type','uicontrol');
chk_win_hist    = findobj(uic_win_hist,'Style','checkbox');
pus_win_hist    = findobj(uic_win_hist,'Style','pushbutton');
chk_det_sig     = findobj(chk_win_hist,'tag',tag_det_sig);
pus_det_all     = findobj(pus_win_hist,'tag',tag_det_all);
rad_sel_cfs     = findobj(uic_win_hist,'Style','radiobutton',...
                                'tag',tag_sel_cfs);
pus_show_hist   = findobj(pus_win_hist,'tag',tag_show_hist);
set(chk_det_sig,'value',1)      
eval(get(chk_det_sig,'Callback'));
pause(1)
eval(get(pus_det_all,'Callback'));
pause(1)
eval(get(rad_sel_cfs,'Callback'));
pause(1)
eval(get(pus_show_hist,'Callback'));
wenamngr('Inactive',win_hist);

stop = demoscen('msg',figNumber,wait_mode,10,win_msg,win_dw1d);
if stop , return; end

dw1dhist('close',win_hist);
delete(win_hist)


% figure 6 - Compress - initial window.
%--------------------------------------
stop = demoscen('msg',figNumber,wait_mode,11,win_msg,win_dw1d);
if stop , return; end

win_comp = dw1dmngr('comp',win_dw1d);
wenamngr('Inactive',win_comp);
% UTTHRGBL handlesUIC (Compression).
%----------------------------------------------------
% ud.handlesUIC = ...
%   [fra_utl;txt_top;pop_met;...
%    txt_sel;sli_sel;edi_sel; ...
%    txt_nor;edi_nor;txt_npc;...
%    txt_zer;edi_zer;txt_zpc;...
%    tog_res;pus_est];
%----------------------------------------------------
pop_mod    = wmemtool('rmb',win_comp,n_misc_comp,ind_pop_mod);
handlesUIC = utthrgbl('handlesUIC',win_comp);
edi_zer    = handlesUIC(11);

% figure 7 - Compress - after compression with 
%            the threshold default value.
%----------------------------------------------
stop = demoscen('msg',figNumber,wait_mode,12,win_msg,win_dw1d);
if stop , return; end

dw1dcomp('compress',win_comp,win_dw1d);
wenamngr('Inactive',win_comp);
if wshowdrv('pause',figNumber,wait_mode) , return; end;

stop = demoscen('msg',figNumber,wait_mode,13,win_msg,win_dw1d);
if stop , return; end

set(edi_zer,'String',num2str(96.4));
eval(get(edi_zer,'Callback'));
dw1dcomp('compress',win_comp,win_dw1d);
wenamngr('Inactive',win_comp);
if wshowdrv('pause',figNumber,wait_mode), return; end;

% figure 8 - Compress - manual thresholding window.
%--------------------------------------------------
stop = demoscen('msg',figNumber,wait_mode,14,win_msg,win_dw1d);
if stop , return; end

set(pop_mod,'Value',2)
eval(get(pop_mod,'Callback'))
wenamngr('Inactive',win_comp);
if wshowdrv('pause',figNumber,wait_mode), return; end;
dw1dcomp('compress',win_comp,win_dw1d);
wenamngr('Inactive',win_comp);
if wshowdrv('pause',figNumber,wait_mode), return; end;
wmemtool('wmb',win_comp,n_misc_comp,ind_status,0);
dw1dcomp('close',win_comp);
wenamngr('Inactive',win_dw1d);
delete(win_comp)

% figure 9 - De-noise - Fixed form  soft thresholding window.
%------------------------------------------------------------
stop = demoscen('msg',figNumber,wait_mode,15,win_msg,win_dw1d);
if stop , return; end

win_deno = dw1dmngr('deno',win_dw1d);
wenamngr('Inactive',win_deno);
% UTTHRW1D handlesUIC (De-noising).
%-------------------------------------
% ud.handlesUIC = ...
%   [fra_utl;txt_top;pop_met; ...
%    rad_sof;rad_har;txt_noi;pop_noi; ...
%    txt_BMS;sli_BMS;txt_tit(1:4),...
%    txt_nor;edi_nor;txt_npc; ...
%    txt_zer;edi_zer;txt_zpc; ...
%    tog_thr;tog_res;pus_est];
%----------------------------------------------------------
handlesUIC = utthrw1d('handlesUIC',win_deno);
pop_met    = handlesUIC(3);
rad_har    = handlesUIC(5);

pause(1)
dw1ddeno('denoise',win_deno,win_dw1d);
wenamngr('Inactive',win_deno);
stop = demoscen('msg',figNumber,wait_mode,18,win_msg,win_dw1d);
if stop , return; end

% figure 10 - De-noise - Fixed form hard thresholding window.
%-------------------------------------------------------------
set(rad_har,'Value',1)
eval(get(rad_har,'Callback'))
dw1ddeno('denoise',win_deno,win_dw1d);
wenamngr('Inactive',win_deno);
stop = demoscen('msg',figNumber,wait_mode,19,win_msg,win_dw1d);
if stop , return; end

% figure 11 - De-noise - Penalize medium thresholding window.
%--------------------------------------------------------------
set(pop_met,'Value',6)
eval(get(pop_met,'Callback'))
if wshowdrv('pause',figNumber,wait_mode) , return; end;
dw1ddeno('denoise',win_deno,win_dw1d);
wenamngr('Inactive',win_deno);
stop = demoscen('msg',figNumber,wait_mode,20,win_msg,win_dw1d);
if stop , return; end

% Writing Synthesized. Signal Type.
%----------------------------------
wwaiting('msg',win_deno,'Wait ... computing');
lin_den = utthrw1d('get',win_deno,'handleTHR');
wmemtool('wmb',win_dw1d,n_param_anal,ind_ssig_type,'ds');
dw1dmngr('return_deno',win_dw1d,1,lin_den);
wenamngr('Inactive',win_dw1d);
wwaiting('off',win_deno);
delete(win_deno)
dmsgfun('close');
if wshowdrv('pause',figNumber,wait_mode), return; end;

dw1ddisp('create',win_dw1d);
win_mopt = wfindobj('figure','tag',tag_win_disp);
if wshowdrv('pause',figNumber,wait_mode), return; end;
uic_win_mopt = findobj(win_mopt,'Type','uicontrol');
chk_win_mopt = findobj(uic_win_mopt,'Style','checkbox');
chk_cfs_on   = findobj(chk_win_mopt,'Tag',tag_cfs_on);
set(chk_cfs_on,'Value',0);
pause(1)
dw1ddisp('apply',win_dw1d,win_mopt);
if wshowdrv('pause',figNumber,wait_mode), return; end;
dw1ddisp('close',win_dw1d,win_mopt);
wenamngr('Inactive',win_dw1d);

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    dw1dtool('close',win_dw1d);
    delete(win_dw1d)
    demoscen('close');
end
