function [out1,out2] = dmsgfun(option,in2,in3,in4)
%DMSGFUN  Message function for demos in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 25-Feb-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.15 $

% Tag property of objects.
%------------------------
tag_dmsgfig  = 'Wdmsgfig';
tag_axeinfo  = 'Axe_info';
tag_txt_info = 'Txt_info';

figdmsg      = wfindobj('figure','tag',tag_dmsgfig);
dy0          = 18;
switch option
    case 'create'
        % Get Globals.
        %-------------
        [...
        Def_Btn_Height,Def_Btn_Width,Pop_Min_Width,   ...
        X_Graph_Ratio,X_Spacing,Y_Spacing,            ...
        Def_TxtBkColor,Def_EdiBkColor,Def_FraBkColor, ...
        Lst_ColorMap] = ...
            mextglob('get',...
                'Def_Btn_Height','Def_Btn_Width','Pop_Min_Width',   ...
                'X_Graph_Ratio','X_Spacing','Y_Spacing',            ...
                'Def_TxtBkColor','Def_EdiBkColor','Def_FraBkColor', ...
                'Lst_ColorMap'                                      ...
                );

        if isempty(figdmsg)
            win_units  = 'pixels';
            win_height = 6*Def_Btn_Height;
            pos_win = zeros(1,4);
            if nargin==3 ,  win_view = in3; else, win_view = 0; end
            Screen_Size  = get(0,'ScreenSize');
            if win_view>0
                old_u = get(in3,'units');
                set(win_view,'units','pixels');
                pos_call_win = get(win_view,'Position');
                win_width = 4*pos_call_win(3)/5;
                xleft   = pos_call_win(1)+(pos_call_win(3)-win_width)/2;
                set(win_view,'units',old_u);
                pos_win   = [ xleft                      ,...
                              pos_call_win(2)-win_height ,...
                              win_width                  ,...
                              win_height                  ...
                              ];
            else
                win_width = round(Def_Btn_Width+2*Pop_Min_Width+6*X_Spacing/(1-X_Graph_Ratio));
                pos_win   = [ Screen_Size(3)-5-win_width ,...
                              0                          ,...
                              win_width                  ,...
                              win_height                  ...
                              ];
            end
            pos_win(2) = depOfMachine(pos_win(2));
            axe_col = Def_TxtBkColor;
            figdmsg = colordef('new','none');
            set(figdmsg,...
                    'MenuBar','none',...
                    'DefaultUicontrolBackgroundcolor',Def_FraBkColor, ...
                    'Name','Information window',...
                    'Visible','off',...
                    'Unit',win_units,...
                    'Position',pos_win,...
                    'Color',axe_col,...
                    'DefaultAxesXColor',axe_col,...
                    'DefaultAxesYColor',axe_col,...
                    'DefaultAxesZColor',axe_col,...
                    'NumberTitle','off',...
                    'Tag',tag_dmsgfig...
                    );
            p_axe   = [0 0 win_width win_height];
            a       = axes(...
                    'Parent',figdmsg,                ...
                    'Visible','off',                 ...
                    'Units','pixels',                ...
                    'Position',p_axe,                ...
                    'DrawMode','Fast',               ...
                    'XTicklabelMode','manual',       ...
                    'YTicklabelMode','manual',       ...
                    'XTicklabel',[],'YTicklabel',[], ...
                    'Box','On',                      ...
                    'XGrid','off','YGrid','off',     ...
                    'color',axe_col,                 ...
                    'Tag',tag_axeinfo                ...
                    );
            set([figdmsg,a],'units','normalized','Visible','on');
            set(figdmsg,'Name',['Message window']);
        else
            hidegui(figdmsg,'on');
            a = findobj(figdmsg,'Tag',tag_axeinfo);
            t = findobj(a,'Tag',tag_txt_info);
            delete(t);
            figure(figdmsg);
        end
        Deffontsize = get(0,'DefaultTextFontSize');
        dim     = size(in2,1);
        if isempty(dim) , return; end
        old_u   = get(a,'units');
        set(a,'units','pixels');
        txt_col = [0 0 0];
        p_axe   = get(a,'Position');
        dy      = dy0;
        dx      = 20;
        y1      = p_axe(4);
        nbt_vis = floor(y1/dy0)-1;
        invis   = 0;
        t       = zeros(1,dim);
        axes(a);
        for k = 1:dim
            y1 = y1-dy;
            if y1<dy0/2
                invis = invis+1;
                vis   = 'off';
            else
                vis   = 'on';
            end
            t(k) = text(dx,y1,in2(k,:),             ...
                            'units','pixels',       ...
                            'fontname','courier',   ...
                            'fontsize',Deffontsize, ...
                            'Color',txt_col,        ...
                            'Visible',vis,          ...
                            'Userdata',k,           ...
                            'tag',tag_txt_info,     ...
                            'parent',a);              
        end
        set(a,'units',old_u);
        set(t,'units','normalized');
        hidegui(figdmsg,'off');

    case 'win'
        out1 = figdmsg;

    case 'close'
        delete(figdmsg);
end

%-------------------------------------------------
function varargout = depOfMachine(varargin)

xleft = varargin{1};
scrSize = get(0,'ScreenSize');
if scrSize(4)<800 , xleft = 20; end
varargout{1} =  xleft;
%-------------------------------------------------
